/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.gui.Colors;
import com.hastobe.transparenzsoftware.gui.views.MainView;
import com.hastobe.transparenzsoftware.gui.views.VerifyResult;
import com.hastobe.transparenzsoftware.gui.views.customelements.ErrorLog;
import com.hastobe.transparenzsoftware.gui.views.customelements.HintTextField;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;
import com.hastobe.transparenzsoftware.verification.xml.LocalDateTimeAdapter;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class VerifyDataView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 768;
    public static final Dimension SIZE_SCROLLPANE_VISIBLE = new Dimension(800, 640);
    public static final Dimension SIZE_SCROLL_PANE_CLOSED = new Dimension(800, 10);
    private static final String TEXT_NO_DATA_PRESENT = "app.view.nodata";
    private static final String TEXT_PLEASE_OPEN_FILE = "app.view.openfile.help";
    private static final String TEXT_PUBLIC_KEY = "app.public.key";
    private JLabel iconLabel;
    private ImageIcon icon;
    private JLabel imageLabel;
    private JLabel meterLabel;
    private ErrorLog warningLabel;
    private JLabel initialHelpLabel;
    private JLabel meterDescLabel;
    private final HintTextField publicKeyField;
    private final JLabel publicKeyLabel;
    private Border tfDefaultBorder;
    private AtomicBoolean eventsEnabled = new AtomicBoolean();

    public VerifyDataView(MainView mainView) {
        this.setMinimumSize(new Dimension(1024, 768));
        this.setName("wnd.verifier");
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(2, 2));
        this.publicKeyLabel = new JLabel("<html>" + Translator.get(TEXT_PUBLIC_KEY) + "</html>");
        this.publicKeyField = new HintTextField(mainView, this.eventsEnabled);
        this.publicKeyField.setColumns(60);
        this.publicKeyField.setRows(4);
        this.publicKeyField.setName("text.pubkey");
        this.initComponents();
        JPanel paneTop = new JPanel();
        BoxLayout layoutManagerTop = new BoxLayout(paneTop, 3);
        paneTop.setLayout(layoutManagerTop);
        int innerMargin = 5;
        Border debugBorder = BorderFactory.createEmptyBorder(innerMargin, innerMargin, innerMargin, innerMargin);
        paneTop.setBorder(debugBorder);
        int westWidth = 180;
        paneTop.add(Box.createRigidArea(new Dimension(westWidth, 10)));
        paneTop.add(this.imageLabel);
        paneTop.add(this.iconLabel);
        paneTop.add(Box.createRigidArea(new Dimension(westWidth, 10)));
        pane.add((Component)paneTop, "West");
        JPanel paneMiddle = new JPanel();
        paneMiddle.setLayout(new BoxLayout(paneMiddle, 3));
        paneMiddle.add(Box.createVerticalStrut(20));
        paneMiddle.add(this.meterDescLabel);
        this.meterDescLabel.setBorder(debugBorder);
        paneMiddle.add(Box.createVerticalStrut(5));
        this.meterLabel.setBorder(debugBorder);
        paneMiddle.add(this.meterLabel);
        paneMiddle.add(Box.createVerticalStrut(10));
        this.warningLabel.setBorder(debugBorder);
        paneMiddle.add(this.warningLabel);
        paneMiddle.add(this.initialHelpLabel);
        paneMiddle.add(Box.createVerticalStrut(5));
        paneMiddle.setBorder(debugBorder);
        paneMiddle.add(Box.createVerticalGlue());
        pane.add((Component)paneMiddle, "Center");
        JPanel keyPanel = new JPanel();
        BorderLayout layout = new BorderLayout(50, 50);
        keyPanel.setLayout(layout);
        keyPanel.add((Component)this.publicKeyLabel, "West");
        JScrollPane scrollPublicKey = new JScrollPane(this.publicKeyField);
        keyPanel.add((Component)scrollPublicKey, "Center");
        JScrollPane scrollData = new JScrollPane(pane);
        scrollData.setHorizontalScrollBarPolicy(30);
        scrollData.setVerticalScrollBarPolicy(20);
        this.setLayout(new BorderLayout(20, 20));
        this.add((Component)scrollData, "Center");
        this.add((Component)keyPanel, "South");
        this.clearInputs();
        this.validate();
        this.repaint();
        this.setAutoscrolls(true);
    }

    private void initComponents() {
        this.meterDescLabel = new JLabel(Translator.get("app.view.meter"));
        this.meterDescLabel.setAlignmentX(0.5f);
        this.meterLabel = new JLabel("", 0);
        this.meterLabel.setAlignmentX(0.5f);
        this.meterLabel.setName("lbl.meter");
        HashMap<TextAttribute, Serializable> textAttrMap = new HashMap<TextAttribute, Serializable>();
        textAttrMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        textAttrMap.put(TextAttribute.FOREGROUND, Color.BLUE);
        this.iconLabel = new JLabel();
        this.iconLabel.setAlignmentX(0.5f);
        this.iconLabel.setMinimumSize(new Dimension(250, 64));
        this.iconLabel.setName("lbl.icon");
        this.imageLabel = new JLabel();
        this.imageLabel.setAlignmentX(0.5f);
        this.imageLabel.setName("lbl.image");
        this.imageLabel.setMinimumSize(new Dimension(64, 64));
        this.warningLabel = new ErrorLog();
        this.warningLabel.setAlignmentX(0.5f);
        this.warningLabel.setName("lbl.warn");
        this.initialHelpLabel = new JLabel();
        this.initialHelpLabel.setAlignmentX(0.5f);
        this.initialHelpLabel.setName("lbl.openfile");
    }

    public void setState(VerificationResult verificationResult) {
        if (verificationResult == null) {
            this.clearVerificationResult();
            return;
        }
        this.initialHelpLabel.setVisible(false);
        this.setVerifyIconAndLabel(verificationResult.isVerified() ? VerifyResult.VERIFIED_OK : VerifyResult.VERIFIED_BAD);
        if (verificationResult.getErrorMessages().size() > 0) {
            this.warningLabel.setText(verificationResult.getErrorMessages());
            this.warningLabel.setVisible(true);
        } else {
            this.warningLabel.setVisible(false);
        }
        this.setMeters(verificationResult.getMeters(), verificationResult.isTransactionResult());
        this.validate();
        this.repaint();
        this.doLayout();
        this.tfDefaultBorder = this.iconLabel.getBorder();
    }

    private void setVerifyIconAndLabel(VerifyResult vr) {
        String imgResourcePath = "";
        String iconTextLabel = "";
        switch (vr) {
            case NOT_YET_VERIFIED: {
                iconTextLabel = "app.view.verify.notYet";
                imgResourcePath = "gui/not_yet_verified.png";
                break;
            }
            case VERIFIED_BAD: {
                iconTextLabel = "app.view.verify.failure";
                imgResourcePath = "gui/not_verified.png";
                break;
            }
            case VERIFIED_OK: {
                iconTextLabel = "app.view.verify.success";
                imgResourcePath = "gui/verified.png";
            }
        }
        URL imgStatePath = ClassLoader.getSystemResource(imgResourcePath);
        String translation = Translator.get(iconTextLabel);
        this.icon = new ImageIcon(imgStatePath);
        Image image = this.icon.getImage();
        Image scaledImage = image.getScaledInstance(100, 100, 4);
        this.icon = new ImageIcon(scaledImage);
        this.iconLabel.setText(translation);
        this.imageLabel.setIcon(this.icon);
    }

    private void clearVerificationResult() {
        this.setVerifyIconAndLabel(VerifyResult.NOT_YET_VERIFIED);
        this.warningLabel.setVisible(false);
        this.initialHelpLabel.setText(Translator.get(TEXT_PLEASE_OPEN_FILE));
        this.initialHelpLabel.setVisible(true);
        this.meterLabel.setVisible(false);
        this.meterDescLabel.setVisible(false);
    }

    private String html(String locText) {
        return "<HTML><BODY>" + Translator.get(locText) + "</BODY></HTML>";
    }

    public void clearErrorMessage() {
        this.setVerifyIconAndLabel(VerifyResult.NOT_YET_VERIFIED);
    }

    private List<Meter> filterLawRelevant(List<Meter> meters) {
        ArrayList<Meter> result = new ArrayList<Meter>();
        for (Meter m3 : meters) {
            if (!m3.isLawRelevant()) continue;
            result.add(m3);
        }
        return result;
    }

    private void setMeters(List<Meter> meters, boolean transactionResult) {
        if ((meters = this.filterLawRelevant(meters)).size() <= 0) {
            return;
        }
        boolean addStart = false;
        boolean addStop = false;
        int numElements = meters.size();
        int index = 1;
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body><ul style=\"list-style-type: none; margin-left: 0px\">");
        String preci = null;
        int digitsScaler = Integer.MAX_VALUE;
        int lastStopIndex = -1;
        for (Meter meter : meters) {
            if (meter.getType() == Meter.Type.STOP) {
                lastStopIndex = index;
            }
            ++index;
        }
        index = 1;
        for (Meter meter : meters) {
            if (meter.getScaling() < digitsScaler) {
                preci = meter.getScalingFormat();
                digitsScaler = meter.getScaling();
            }
            if (meter.getType() != null) {
                if (meter.getType() == Meter.Type.START && !addStart) {
                    addStart = true;
                    this.AddOverviewDisplayElements(builder, meter);
                }
                if (meter.getType() == Meter.Type.UPDATE && addStart) {
                    this.AddOverviewDisplayElements(builder, meter);
                }
                if (meter.getType() == Meter.Type.STOP && !addStop && lastStopIndex == index) {
                    addStop = true;
                    this.AddOverviewDisplayElements(builder, meter);
                }
            } else {
                this.AddOverviewDisplayElements(builder, meter);
            }
            ++index;
        }
        if (transactionResult) {
            Meter.TimeSyncType timeSyncType = Meter.getTimeSyncType(meters);
            builder.append("<li>&nbsp;</li>");
            builder.append("<li>");
            if (timeSyncType == Meter.TimeSyncType.SYNCHRONIZED || timeSyncType == Meter.TimeSyncType.REALTIME) {
                builder.append(String.format("%s ", Translator.get("app.view.time.difference")));
            } else {
                builder.append(String.format("%s ", Translator.get("app.view.time.difference.informative")));
            }
            builder.append("<ul style=\"list-style-type: none;margin-left: 0;\">");
            Duration timeDiff = Meter.getTimeDiff(meters);
            builder.append(String.format("<li>%s</li>", Utils.formatDuration(timeDiff)));
            builder.append("</ul>");
            builder.append("</li>");
            builder.append("<li>&nbsp;</li>");
            builder.append("<li>");
            builder.append(String.format("%s ", Translator.get("app.view.energy.difference")));
            builder.append("<ul style=\"list-style-type: none;margin-left: 0;\">");
            builder.append(String.format("<li>" + preci + " kWh</li>", Meter.getDifference(meters)));
            builder.append("</ul>");
            builder.append("</li>");
        }
        builder.append("</ul></body></html>");
        this.meterLabel.setVisible(true);
        this.meterDescLabel.setVisible(true);
        this.meterLabel.setText(builder.toString());
        this.meterLabel.setToolTipText(Translator.get("app.view.datetime.time.station"));
        this.validate();
    }

    private void AddOverviewDisplayElements(StringBuilder builder, Meter meter) {
        if (!meter.isLawRelevant()) {
            return;
        }
        builder.append("<li>");
        if (meter.getDescriptiveMessageText() != null) {
            builder.append(meter.getDescriptiveMessageText());
        } else if (meter.getType() != null) {
            builder.append(Translator.get(meter.getType().message));
        }
        builder.append("</li>");
        builder.append("<li>");
        String preci = meter.getScalingFormat();
        builder.append(String.format(preci + " kWh", meter.getValue()));
        builder.append("</li><li>");
        LocalDateTime localDateTime = meter.getTimestamp() != null ? meter.getTimestamp().toLocalDateTime() : null;
        builder.append(LocalDateTimeAdapter.formattedDateTime(localDateTime));
        builder.append(" (<span style=\"color: blue\">lokal</span>)");
        if (!meter.getAdditonalText().isEmpty()) {
            builder.append(String.format(" (%s)", meter.getAdditonalText()));
        }
        builder.append("</li>");
        builder.append("<li>&nbsp;</li>");
    }

    public void clearInputs() {
        this.clearVerificationResult();
        this.setEnabled(false);
        this.publicKeyField.setText("");
    }

    public void fillUpContent(String publicKeyContent, boolean indeterminate) {
        if (publicKeyContent == null) {
            publicKeyContent = "";
        }
        this.setEnabled(false);
        this.publicKeyField.setHint(Translator.get("app.view.pubkey.ok"));
        this.publicKeyField.setText(publicKeyContent);
    }

    public void setPublicKey(String parsePublicKey) {
        this.fillUpContent(parsePublicKey, false);
    }

    public void setPublicKeyWarning(boolean warn) {
        if (warn) {
            this.publicKeyField.setBorder(BorderFactory.createLineBorder(Colors.WARNING_LOG));
        } else {
            this.publicKeyField.setBorder(this.tfDefaultBorder);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.eventsEnabled.set(b);
        this.publicKeyField.setEnabled(b);
    }

    public String getPublicKeyContent() {
        return this.publicKeyField.getText();
    }
}

