/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import com.hastobe.transparenzsoftware.gui.listeners.TextareaChangedListeners;
import com.hastobe.transparenzsoftware.gui.views.MainView;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTextArea;

public class HintTextField
extends JTextArea {
    private static final long serialVersionUID = 6239343587111979420L;
    private String hint = "";

    public HintTextField(MainView mainView, AtomicBoolean eventsEnabled) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.getDocument().addDocumentListener(new TextareaChangedListeners(mainView, eventsEnabled));
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.getText().length() == 0) {
            int h2 = this.getHeight();
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Insets ins = this.getInsets();
            FontMetrics fm = g2.getFontMetrics();
            int c0 = this.getBackground().getRGB();
            int c1 = this.getForeground().getRGB();
            int m3 = -16843010;
            int c2 = ((c0 & m3) >>> 1) + ((c1 & m3) >>> 1);
            g2.setColor(new Color(c2, true));
            g2.drawString(this.hint, ins.left, h2 / 2 + fm.getAscent() / 2 - 2);
        }
    }
}

