/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import com.hastobe.transparenzsoftware.gui.views.DetailDataView;
import com.hastobe.transparenzsoftware.gui.views.MainView;
import com.hastobe.transparenzsoftware.gui.views.VerifyDataView;
import com.hastobe.transparenzsoftware.gui.views.customelements.ErrorLog;
import com.hastobe.transparenzsoftware.gui.views.customelements.MainViewErrorPanel;
import com.hastobe.transparenzsoftware.gui.views.customelements.RawDataPanel;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MainViewCenterPanel
extends JPanel {
    private static final String TEXT_USER_DATA = "app.view.userdata";
    private static final String TEXT_RAW_DATA = "app.view.dataset";
    private static final String TEXT_DETAIL_DATA = "app.view.datadetails";
    public static final String PASTE_FROM_CLIPBOARD_ACTION = "paste-from-clipboard";
    private final MainViewErrorPanel errorPanel;
    private final JTabbedPane tabPane = new JTabbedPane();
    private final JPanel lowerPanel;
    private final RawDataPanel raw;
    private final VerifyDataView verifyDataView;
    private final DetailDataView detailDataView;

    public MainViewCenterPanel(MainView mainView) {
        this.verifyDataView = new VerifyDataView(mainView);
        this.tabPane.addTab(Translator.get(TEXT_USER_DATA), this.verifyDataView);
        this.detailDataView = new DetailDataView(mainView);
        this.tabPane.addTab(Translator.get(TEXT_DETAIL_DATA), this.detailDataView);
        this.raw = new RawDataPanel(mainView);
        this.tabPane.addTab(Translator.get(TEXT_RAW_DATA), this.raw);
        this.lowerPanel = new JPanel();
        this.setLayout(new BorderLayout());
        ErrorLog eLog = new ErrorLog();
        eLog.setName("lbl.elog");
        this.errorPanel = new MainViewErrorPanel(eLog);
        this.add((Component)this.tabPane, "Center");
        this.add((Component)this.lowerPanel, "South");
    }

    public void showFirstPane() {
        this.tabPane.setSelectedIndex(0);
    }

    public void setErrorMessage(String message) {
        this.lowerPanel.removeAll();
        this.lowerPanel.add(this.errorPanel);
        this.errorPanel.setErrorText(message, false);
    }

    public void setWarningMessage(String message) {
        this.lowerPanel.removeAll();
        this.lowerPanel.add(this.errorPanel);
        this.errorPanel.setErrorText(message, false);
    }

    public void clearErrorMessage() {
        this.lowerPanel.removeAll();
        this.errorPanel.setErrorText("", true);
        this.verifyDataView.clearErrorMessage();
        this.detailDataView.clearErrorMessage();
        this.repaint();
        this.revalidate();
        this.updateUI();
    }

    public void clearInputs() {
        this.raw.clearInputs();
        this.verifyDataView.clearInputs();
    }

    public String getRawDataContent() {
        return this.raw.getRawDataContent();
    }

    public void cleanUpNoiseInRawData() {
        this.raw.cleanUpNoiseInRawData();
    }

    public String getPublicKeyContent() {
        return this.verifyDataView.getPublicKeyContent();
    }

    public void fillUpContent(String rawDataContent, String publicKeyContent, boolean indeterminate, EncodingType encoding, VerificationType type) {
        this.raw.fillUpContent(rawDataContent, encoding, type);
        this.verifyDataView.fillUpContent(publicKeyContent, indeterminate);
    }

    public VerificationType getVerificationType() {
        return this.raw.getVerificationType();
    }

    public EncodingType getEncoding() {
        return this.raw.getEncoding();
    }

    public void setEncoding(EncodingType encodingType) {
        this.raw.setEncoding(encodingType);
    }

    public void setVerificationType(VerificationType verificationType) {
        this.raw.setVerificationType(verificationType);
    }

    public void setPublicKey(String parsePublicKey) {
        this.verifyDataView.setPublicKey(parsePublicKey);
    }

    public void setPublicKeyWarning(boolean warn) {
        this.verifyDataView.setPublicKeyWarning(warn);
    }

    public void setEnabledFields(boolean b) {
        this.raw.setEnabled(false);
        this.verifyDataView.setEnabled(b);
    }

    public boolean isErrorMessageSet() {
        return this.errorPanel.isErrorMessageSet();
    }

    public void setVerificationContent(VerificationResult verificationResult) {
        this.verifyDataView.setState(verificationResult);
        this.detailDataView.setAdditionalData(verificationResult.getAdditionalVerificationData());
    }
}

