/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import com.hastobe.transparenzsoftware.gui.listeners.AboutBtnListener;
import com.hastobe.transparenzsoftware.gui.listeners.CloseAppListener;
import com.hastobe.transparenzsoftware.gui.listeners.GotoBtnListener;
import com.hastobe.transparenzsoftware.gui.listeners.HelpBtnListener;
import com.hastobe.transparenzsoftware.gui.listeners.ManualInputBtnListener;
import com.hastobe.transparenzsoftware.gui.listeners.OpenFileBtnListener;
import com.hastobe.transparenzsoftware.gui.views.MainView;
import com.hastobe.transparenzsoftware.i18n.Translator;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MainViewMenu
extends JMenuBar {
    private final JMenu fileMenu = new JMenu(Translator.get("app.view.file"));
    private final JMenu gotoMenu;
    private final JMenuItem gotoNextItem;
    private final JMenuItem gotoPreviousItem;
    private final JMenu infoMenu;

    public MainViewMenu(MainView mainView) {
        this.fileMenu.setName("menu.top");
        JMenuItem fileItem = new JMenuItem(Translator.get("app.view.openfile"));
        fileItem.getAccessibleContext().setAccessibleDescription(Translator.get("app.view.openfile.description"));
        fileItem.addActionListener(new OpenFileBtnListener(mainView));
        fileItem.setName("menu.file");
        KeyStroke keyO = KeyStroke.getKeyStroke(79, 128);
        fileItem.setAccelerator(keyO);
        this.fileMenu.add(fileItem);
        JMenuItem pasteItem = new JMenuItem(Translator.get("app.view.pastefile"));
        pasteItem.getAccessibleContext().setAccessibleDescription(Translator.get("app.view.pastefile.description"));
        pasteItem.addActionListener(new ManualInputBtnListener(mainView));
        pasteItem.setName("menu.paste");
        KeyStroke key1 = KeyStroke.getKeyStroke(77, 128);
        pasteItem.setAccelerator(key1);
        this.fileMenu.add(pasteItem);
        JMenuItem closeItem = new JMenuItem(Translator.get("app.view.exit"));
        closeItem.getAccessibleContext().setAccessibleDescription(Translator.get("app.view.exit.description"));
        closeItem.addActionListener(new CloseAppListener(mainView));
        KeyStroke keyQ = KeyStroke.getKeyStroke(81, 128);
        closeItem.setAccelerator(keyQ);
        closeItem.setName("menu.close");
        this.fileMenu.add(closeItem);
        this.add(this.fileMenu);
        this.gotoMenu = new JMenu(Translator.get("app.view.goto"));
        this.gotoPreviousItem = new JMenuItem(Translator.get("app.view.previous"));
        this.gotoPreviousItem.addActionListener(new GotoBtnListener(mainView, GotoBtnListener.Direction.PREVIOUS));
        this.setGotoPreviousItemEnabled(false);
        KeyStroke keyP = KeyStroke.getKeyStroke(80, 128);
        this.gotoPreviousItem.setAccelerator(keyP);
        this.gotoPreviousItem.setName("menu.prev");
        this.gotoMenu.add(this.gotoPreviousItem);
        this.gotoNextItem = new JMenuItem(Translator.get("app.view.next"));
        this.gotoNextItem.addActionListener(new GotoBtnListener(mainView, GotoBtnListener.Direction.NEXT));
        KeyStroke keyN = KeyStroke.getKeyStroke(78, 128);
        this.gotoNextItem.setAccelerator(keyN);
        this.gotoNextItem.setName("menu.next");
        this.setGotoNextItemEnabled(false);
        this.gotoMenu.add(this.gotoNextItem);
        this.add(this.gotoMenu);
        this.infoMenu = new JMenu(Translator.get("app.view.help"));
        JMenuItem helpItem = new JMenuItem(Translator.get("app.view.help"));
        helpItem.addActionListener(new HelpBtnListener(mainView));
        helpItem.getAccessibleContext().setAccessibleDescription(Translator.get("app.view.help.description"));
        helpItem.setName("menu.help");
        this.infoMenu.add(helpItem);
        JMenuItem aboutItem = new JMenuItem(Translator.get("app.view.about"));
        aboutItem.getAccessibleContext().setAccessibleDescription("app.view.about.description");
        aboutItem.addActionListener(new AboutBtnListener(mainView));
        aboutItem.setName("menu.about");
        this.infoMenu.add(aboutItem);
        this.add(this.infoMenu);
    }

    public void setGotoNextItemEnabled(boolean enabled) {
        this.gotoNextItem.setEnabled(enabled);
    }

    public void setGotoPreviousItemEnabled(boolean enabled) {
        this.gotoPreviousItem.setEnabled(enabled);
    }
}

