/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.output;

import com.hastobe.transparenzsoftware.gui.views.helper.ValueIndexHolder;
import com.hastobe.transparenzsoftware.gui.views.helper.ValueMapBuilder;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.output.Output;
import com.hastobe.transparenzsoftware.verification.TransactionValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationParser;
import com.hastobe.transparenzsoftware.verification.VerificationParserFactory;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.VerificationTypeNotImplementedException;
import com.hastobe.transparenzsoftware.verification.Verifier;
import com.hastobe.transparenzsoftware.verification.input.InputReader;
import com.hastobe.transparenzsoftware.verification.input.InvalidInputException;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;
import com.hastobe.transparenzsoftware.verification.xml.Value;
import com.hastobe.transparenzsoftware.verification.xml.Values;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsoleFileProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ConsoleFileProcessor.class);
    private final Verifier verifier;
    private final VerificationParserFactory factory;

    public ConsoleFileProcessor(VerificationParserFactory factory) {
        this.verifier = new Verifier(factory);
        this.factory = factory;
    }

    public boolean processFile(String path, String outputPath) {
        Map<BigInteger, List<ValueIndexHolder>> transactionMap;
        Values values;
        InputReader inputReader = new InputReader();
        File file = new File(path);
        if (!file.isFile()) {
            System.err.println(Translator.get("error.path.not.a.file"));
        }
        File outputFile = null;
        if (outputPath != null) {
            outputFile = new File(outputPath);
            if (!outputFile.isFile()) {
                try {
                    outputFile.createNewFile();
                }
                catch (IOException e) {
                    System.err.println(String.format(Translator.get("error.cannot.create.file"), outputPath));
                    return false;
                }
                if (!outputFile.canWrite()) {
                    System.err.println(String.format(Translator.get("error.cannot.write.file"), outputFile.getName()));
                    return false;
                }
            } else {
                System.err.println(Translator.get("error.outputfile.exists.already"));
                return false;
            }
        }
        try {
            values = inputReader.readFile(file);
        }
        catch (InvalidInputException e) {
            System.err.println(e.getMessage());
            return false;
        }
        try {
            transactionMap = ValueMapBuilder.buildTransactionMap(values);
        }
        catch (InvalidInputException e) {
            System.err.println(e.getLocalizedMessage());
            return false;
        }
        transactionMap.remove(ValueMapBuilder.NO_TRANSACTION_KEY);
        List<VerificationResult> resultList = this.processValues(values);
        for (BigInteger transactionId : transactionMap.keySet()) {
            VerificationResult result;
            VerificationParser parser;
            List<ValueIndexHolder> valueIndexHolders = transactionMap.get(transactionId);
            ArrayList<Value> transactionValues = new ArrayList<Value>();
            VerificationType type = null;
            String publicKey = null;
            for (ValueIndexHolder valueIndexHolder : valueIndexHolders) {
                transactionValues.add(valueIndexHolder.getValue());
                type = valueIndexHolder.getValue().getSignedData().getFormatAsVerificationType();
                if (valueIndexHolder.getValue().getPublicKey() == null) continue;
                publicKey = valueIndexHolder.getValue().getPublicKey().getValue();
            }
            if (type == null) {
                System.err.println("No type given for the values");
                return false;
            }
            try {
                parser = this.factory.getParser(type);
            }
            catch (VerificationTypeNotImplementedException e) {
                System.err.println(e.getLocalizedMessage());
                return false;
            }
            if (transactionValues.size() <= 1) {
                try {
                    String val = ((Value)transactionValues.get(0)).getSignedData().getValue();
                    result = this.verifier.verify(parser, val, publicKey);
                    resultList.clear();
                    resultList.add(result);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getLocalizedMessage());
                    return false;
                }
            }
            try {
                result = this.verifier.verifyTransaction(parser, transactionValues, publicKey);
            }
            catch (TransactionValidationException e) {
                System.err.println(e.getLocalizedMessage());
                return false;
            }
            resultList.add(result);
        }
        try {
            Output output = new Output(this.factory.getVerifiedDataClasses(), resultList, values);
            this.printOutXml(output.createXML(), outputFile);
            return true;
        }
        catch (JAXBException e) {
            LOGGER.error("Could not create xml ", (Throwable)e);
            System.err.println(Translator.get("error.create.xml"));
            return false;
        }
        catch (FileNotFoundException e) {
            System.err.println(String.format(Translator.get("error.cannot.write.file"), outputFile.getName()));
            return false;
        }
    }

    protected void printOutXml(String output, File outputFile) throws FileNotFoundException {
        if (outputFile != null) {
            PrintWriter writer = new PrintWriter(outputFile);
            writer.println(output);
            writer.flush();
            writer.close();
            System.out.println(Translator.get("app.output.outpfile.created"));
        } else {
            System.out.println(output);
        }
    }

    public List<VerificationResult> processValues(Values values) {
        ArrayList<VerificationResult> resultList = new ArrayList<VerificationResult>();
        for (Value value : values.getValues()) {
            resultList.add(this.verifier.verify(value));
        }
        return resultList;
    }
}

