/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification;

import com.hastobe.transparenzsoftware.verification.ASN1Exception;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;

public class ASN1Utils {
    public static byte[] readPublicKey(byte[] asn1Data) throws ASN1Exception {
        ASN1Primitive asn1Primitive;
        ByteArrayInputStream inStream = new ByteArrayInputStream(asn1Data);
        ASN1InputStream asnInputStream = new ASN1InputStream(inStream);
        try {
            asn1Primitive = asnInputStream.readObject();
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not read ASN.1 public key data", e);
        }
        if (!(asn1Primitive instanceof DLSequence)) {
            throw new ASN1Exception("ASN.1 object not a sequence object");
        }
        DLSequence dlSequence = (DLSequence)asn1Primitive;
        if (dlSequence.size() < 2) {
            throw new ASN1Exception("ASN.1 Sequence does not contain enough values for a public key");
        }
        if (!(dlSequence.getObjectAt(1) instanceof DERBitString)) {
            throw new ASN1Exception("ASN.1 Sequence does not contain a DER Bit string which contains the public key value");
        }
        DERBitString derBitString = (DERBitString)dlSequence.getObjectAt(1);
        return derBitString.getBytes();
    }

    public static SignatureRS readSignatureRS(byte[] asn1Signature) throws ASN1Exception {
        ASN1Primitive asn1Primitive;
        ASN1InputStream asn1 = new ASN1InputStream(asn1Signature);
        try {
            asn1Primitive = asn1.readObject();
        }
        catch (IOException e) {
            throw new ASN1Exception("Could not read ASN.1 public key data");
        }
        if (!(asn1Primitive instanceof DLSequence)) {
            throw new ASN1Exception("ASN.1 object not a sequence object");
        }
        DLSequence sequence = (DLSequence)asn1Primitive;
        if (sequence.size() < 2) {
            throw new ASN1Exception("ASN.1 Sequence does not contain enough values for signature values");
        }
        if (!(sequence.getObjectAt(0) instanceof ASN1Integer) || !(sequence.getObjectAt(1) instanceof ASN1Integer)) {
            throw new ASN1Exception("ASN.1 Sequence does not contain integer values");
        }
        BigInteger signatureR = ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue();
        BigInteger signatureS = ((ASN1Integer)sequence.getObjectAt(1)).getPositiveValue();
        return new SignatureRS(signatureR, signatureS);
    }

    public static class SignatureRS {
        private BigInteger r;
        private BigInteger s;

        public SignatureRS(BigInteger r, BigInteger s2) {
            this.r = r;
            this.s = s2;
        }

        public BigInteger getR() {
            return this.r;
        }

        public BigInteger getS() {
            return this.s;
        }
    }
}

