/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.alfen;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.ContainedPublicKeyParser;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationParser;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenReader;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenSignature;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenSignatureVerifier;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenVerifiedData;
import com.hastobe.transparenzsoftware.verification.result.Error;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;

public class AlfenVerificationParser
implements VerificationParser,
ContainedPublicKeyParser {
    private final AlfenReader reader = new AlfenReader();
    private final AlfenSignatureVerifier verifier = new AlfenSignatureVerifier();

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.ALFEN;
    }

    @Override
    public boolean canParseData(String data) {
        try {
            AlfenSignature signatureData = this.reader.parseString(data);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey) {
        VerificationResult result;
        AlfenSignature signatureData;
        try {
            signatureData = this.reader.parseString(data);
        }
        catch (ValidationException e) {
            return new VerificationResult(Error.withValidationException(e));
        }
        boolean verified = false;
        AlfenVerifiedData verifiedData = null;
        Error error = null;
        try {
            verified = this.verifier.verify(publicKey, signatureData.getSignature(), signatureData.getDataset());
            verifiedData = new AlfenVerifiedData(signatureData, EncodingType.PLAIN);
            if (!verified) {
                error = Error.withVerificationFailed();
            }
        }
        catch (ValidationException e) {
            error = Error.withValidationException(e);
        }
        VerificationResult verificationResult = result = verified ? new VerificationResult(verifiedData) : new VerificationResult(verifiedData, error);
        if (verifiedData != null && verified) {
            try {
                verifiedData.calculateAdapterError();
                verifiedData.calculateMeterError();
            }
            catch (RegulationLawException e) {
                result.addError(new Error(Error.Type.VERIFICATION, "Meter error happened", e.getLocalizedMessageKey()));
            }
        }
        return result;
    }

    @Override
    public Class getVerfiedDataClass() {
        return AlfenVerifiedData.class;
    }

    @Override
    public String parsePublicKey(String data) {
        try {
            AlfenSignature signatureData = this.reader.parseString(data);
            return signatureData.getPublicKey();
        }
        catch (ValidationException validationException) {
            return null;
        }
    }

    @Override
    public String createFormattedKey(String data) {
        String parsedKey = this.parsePublicKey(data);
        return Utils.splitStringToGroups(parsedKey, 4);
    }
}

