/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml.IsaEDL40;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.gui.views.helper.DetailsList;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.sml.IsaEDL40.IsaEDL40Signature;
import com.hastobe.transparenzsoftware.verification.xml.LocalDateTimeAdapter;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.VerifiedData;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="verifiedData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IsaSMLVerifiedData
extends VerifiedData {
    private VerificationType verificationType;
    private EncodingType encodingType;
    private String publicKey;
    private int pagination;
    private String serverId;
    private String context;
    private String contractId;
    private String startEcObisId;
    private String startEcValue;
    private OffsetDateTime startEcTime;
    private String startEcStatus;
    private String startEcUnit;
    private String startEcScaler;
    private OffsetDateTime actualEcTime;
    private String actualEcObisId;
    private String actualEcStatus;
    private String actualEcUnit;
    private String actualEcScaler;
    private String startEValueHexString;
    private double startEValue;
    private String actualEValueHexString;
    private double actualEValue;
    private List<Meter> meters;
    private String detailsHeader;
    private String endMessageDescriptiveText = null;

    public IsaSMLVerifiedData(IsaEDL40Signature smlSignature, VerificationType verificationType, EncodingType encodingType, String publicKey) {
        this.verificationType = verificationType;
        this.encodingType = encodingType;
        this.publicKey = publicKey;
        if (smlSignature != null) {
            this.pagination = new BigInteger(Utils.reverseByteOrder(smlSignature.getPagination())).intValue();
            String cntxDesc = " (Start der Ladetransaktion)";
            this.detailsHeader = "Ablesezeitpunkt (Beginn der Ladetransaktion):";
            this.endMessageDescriptiveText = "Z&auml;hlerstand zum Ablesezeitpunkt (Beginn der Ladetransaktion)";
            String getListName = Utils.toFormattedHex(smlSignature.getListNameOfRes());
            if (getListName.equals("81 80 81 62 01 FF")) {
                cntxDesc = " (Update w&auml;hrend der Ladetransaktion)";
                this.detailsHeader = "Ablesezeitpunkt (Update w&auml;hrend der Ladetransaktion):";
                this.endMessageDescriptiveText = "Z&auml;hlerstand zum Ablesezeitpunkt (W&auml;hrend der Ladetransaktion)";
            } else if (getListName.equals("81 80 81 62 02 FF")) {
                cntxDesc = " (Ende der Ladetransaktion)";
                this.detailsHeader = "Ablesezeitpunkt (Ende der Ladetransaktion):";
                this.endMessageDescriptiveText = "Z&auml;hlerstand zum Ablesezeitpunkt (Ende der Ladetransaktion)";
            }
            this.context = Utils.toFormattedHex(smlSignature.getListNameOfRes()) + cntxDesc;
            this.serverId = Utils.toFormattedHex(smlSignature.getServerId());
            this.contractId = Utils.toFormattedHex(Utils.trimPaddingAtEnd(smlSignature.getContractId()));
            this.startEcObisId = Utils.toFormattedHex(smlSignature.getStartEcObisId());
            this.startEcStatus = Utils.toFormattedHex(smlSignature.getStartEcStatus());
            long sEcValue = Utils.bytesToLong(smlSignature.getStartEcValue());
            this.startEcValue = Long.toString(sEcValue);
            this.startEcTime = smlSignature.getTimestampContractIdAsDate();
            this.startEcUnit = Utils.toFormattedHex(smlSignature.getStartEcUnit());
            this.startEcScaler = Utils.toFormattedHex(smlSignature.getStartEcScaler());
            this.actualEcTime = smlSignature.getTimestampAsDate();
            this.actualEcObisId = Utils.toFormattedHex(smlSignature.getActualEcObisId());
            this.actualEcStatus = Utils.toFormattedHex(smlSignature.getActualEcStatus());
            this.actualEcUnit = Utils.toFormattedHex(smlSignature.getActualEcUnit());
            this.actualEcScaler = Utils.toFormattedHex(smlSignature.getActualEcScaler());
            this.meters = new ArrayList<Meter>();
            this.startEValue = Utils.bytesToLong(smlSignature.getStartEcValue());
            this.actualEValue = Utils.bytesToLong(smlSignature.getActualEcValue());
            this.startEValueHexString = Utils.toFormattedHex(smlSignature.getStartEcValue());
            this.startEValue = this.startEValue != 0.0 ? this.startEValue * Math.pow(10.0, smlSignature.getStartEcScaler()) / 1000.0 : 0.0;
            this.actualEValueHexString = Utils.toFormattedHex(smlSignature.getActualEcValue());
            this.actualEValue = this.actualEValue != 0.0 ? this.actualEValue * Math.pow(10.0, smlSignature.getActualEcScaler()) / 1000.0 : 0.0;
            Meter startMeter = new Meter(this.startEValue, this.startEcTime, Meter.Type.START, Meter.TimeSyncType.INFORMATIVE, smlSignature.getStartEcScaler());
            startMeter.setDescriptiveMessageText("Z&auml;hlerstand zu Beginn der Ladetransaktion");
            this.meters.add(startMeter);
            Meter stopMeter = new Meter(this.actualEValue, this.actualEcTime, getListName.equals("81 80 81 62 00 FF") || getListName.equals("81 80 81 62 02 FF") ? Meter.Type.STOP : Meter.Type.UPDATE, Meter.TimeSyncType.INFORMATIVE, smlSignature.getActualEcScaler());
            stopMeter.setDescriptiveMessageText(this.endMessageDescriptiveText);
            this.meters.add(stopMeter);
        }
    }

    @Override
    public List<Meter> getMeters() {
        return this.meters;
    }

    @Override
    public String getFormat() {
        return this.verificationType.name();
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getEncoding() {
        return this.encodingType.getCode();
    }

    @Override
    public DetailsList getAdditionalData() {
        DetailsList additionalData = new DetailsList();
        additionalData.put("Datensatznummer:", this.pagination);
        additionalData.put("OBIS-ID Datensatzkontext", this.context);
        additionalData.put("ServerId:", this.getServerId());
        additionalData.put("Kontrakt ID/Kundenmerkmal:", this.getContractId());
        additionalData.put("Beginn der Ladetransaktion", " ");
        additionalData.put("- OBIS-ID:", this.startEcObisId);
        additionalData.put("- Ablesezeitpunkt:", LocalDateTimeAdapter.formattedDateTime(this.startEcTime.toLocalDateTime()));
        additionalData.put("- Z&auml;hlerstand:", String.format("%.4f kWh", this.startEValue));
        additionalData.put("- Z&auml;hlerstand (HEX):", this.startEValueHexString);
        additionalData.put("- Status:", this.startEcStatus);
        additionalData.put(this.detailsHeader, "  ");
        additionalData.put("- OBIS-ID: ", this.actualEcObisId);
        additionalData.put("- Ablesezeitpunkt: ", LocalDateTimeAdapter.formattedDateTime(this.actualEcTime.toLocalDateTime()));
        additionalData.put("- Z&auml;hlerstand: ", String.format("%.4f kWh", this.actualEValue));
        additionalData.put("- Z&auml;hlerstand (HEX): ", this.actualEValueHexString);
        additionalData.put("- Status: ", this.actualEcStatus);
        return additionalData;
    }

    @Override
    public boolean lawConform(VerifiedData stopValue) throws RegulationLawException, ValidationException {
        return true;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getContractId() {
        return this.contractId;
    }
}

