/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontFactoryImp fontImp;
    public static HashMap colorTable = new HashMap();
    public static HashMap followTags = new HashMap();

    public Chunk createChunk(String string, ChainedProperties chainedProperties) {
        Chunk chunk = new Chunk(string, this.getFont(chainedProperties));
        if (chainedProperties.hasProperty("sub")) {
            chunk.setTextRise(-6.0f);
        } else if (chainedProperties.hasProperty("sup")) {
            chunk.setTextRise(6.0f);
        }
        return chunk;
    }

    private static void setParagraphLeading(Paragraph paragraph, String string) {
        if (string == null) {
            paragraph.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            String string2 = stringTokenizer.nextToken();
            float f = Float.valueOf(string2).floatValue();
            if (!stringTokenizer.hasMoreTokens()) {
                paragraph.setLeading(f, 0.0f);
                return;
            }
            string2 = stringTokenizer.nextToken();
            float f2 = Float.valueOf(string2).floatValue();
            paragraph.setLeading(f, f2);
        }
        catch (Exception exception) {
            paragraph.setLeading(0.0f, 1.5f);
        }
    }

    public static Paragraph createParagraph(HashMap hashMap) {
        Paragraph paragraph = new Paragraph();
        String string = (String)hashMap.get("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(paragraph, (String)hashMap.get("leading"));
        return paragraph;
    }

    public static void createParagraph(Paragraph paragraph, ChainedProperties chainedProperties) {
        String string = chainedProperties.getProperty("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(paragraph, chainedProperties.getProperty("leading"));
        string = chainedProperties.getProperty("before");
        if (string != null) {
            try {
                paragraph.setSpacingBefore(Float.valueOf(string).floatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = chainedProperties.getProperty("after")) != null) {
            try {
                paragraph.setSpacingAfter(Float.valueOf(string).floatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = chainedProperties.getProperty("extraparaspace")) != null) {
            try {
                paragraph.setExtraParagraphSpace(Float.valueOf(string).floatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties chainedProperties) {
        Paragraph paragraph = new Paragraph();
        FactoryProperties.createParagraph(paragraph, chainedProperties);
        return paragraph;
    }

    public static ListItem createListItem(ChainedProperties chainedProperties) {
        ListItem listItem = new ListItem();
        FactoryProperties.createParagraph(listItem, chainedProperties);
        return listItem;
    }

    public Font getFont(ChainedProperties chainedProperties) {
        FontFactoryImp fontFactoryImp;
        String string = chainedProperties.getProperty("face");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens() && !FontFactory.isRegistered(string = stringTokenizer.nextToken().trim())) {
            }
        }
        int n = 0;
        if (chainedProperties.hasProperty("i")) {
            n |= 2;
        }
        if (chainedProperties.hasProperty("b")) {
            n |= 1;
        }
        if (chainedProperties.hasProperty("u")) {
            n |= 4;
        }
        String string2 = chainedProperties.getProperty("size");
        float f = 12.0f;
        if (string2 != null) {
            f = Float.valueOf(string2).floatValue();
        }
        Color color = FactoryProperties.decodeColor(chainedProperties.getProperty("color"));
        String string3 = chainedProperties.getProperty("encoding");
        if (string3 == null) {
            string3 = "Cp1252";
        }
        if ((fontFactoryImp = this.fontImp) == null) {
            fontFactoryImp = FontFactory.getFontImp();
        }
        return fontFactoryImp.getFont(string, string3, true, f, n, color);
    }

    public static Color decodeColor(String string) {
        if (string == null) {
            return null;
        }
        Color color = (Color)colorTable.get(string = string.toLowerCase().trim());
        if (color != null) {
            return color;
        }
        try {
            if (string.startsWith("#")) {
                return new Color(Integer.parseInt(string.substring(1), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontFactoryImp) {
        this.fontImp = fontFactoryImp;
    }

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }
}

