/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeColorMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feColorMatrix";
    }

    /*
     * WARNING - void declaration
     */
    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        void var12_14;
        Filter in = SVGFeColorMatrixElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        int type = SVGFeColorMatrixElementBridge.convertType(filterElement, ctx);
        switch (type) {
            case 2: {
                float a = SVGFeColorMatrixElementBridge.convertValuesToHueRotate(filterElement, ctx);
                ColorMatrixRable colorMatrix = ColorMatrixRable8Bit.buildHueRotate(a);
                break;
            }
            case 3: {
                ColorMatrixRable colorMatrix = ColorMatrixRable8Bit.buildLuminanceToAlpha();
                break;
            }
            case 0: {
                float[][] matrix = SVGFeColorMatrixElementBridge.convertValuesToMatrix(filterElement, ctx);
                ColorMatrixRable colorMatrix = ColorMatrixRable8Bit.buildMatrix(matrix);
                break;
            }
            case 1: {
                float s2 = SVGFeColorMatrixElementBridge.convertValuesToSaturate(filterElement, ctx);
                ColorMatrixRable colorMatrix = ColorMatrixRable8Bit.buildSaturate(s2);
                break;
            }
            default: {
                throw new Error("invalid convertType:" + type);
            }
        }
        var12_14.setSource(in);
        SVGFeColorMatrixElementBridge.handleColorInterpolationFilters((Filter)var12_14, filterElement);
        PadRable8Bit filter = new PadRable8Bit((Filter)var12_14, primitiveRegion, PadMode.ZERO_PAD);
        SVGFeColorMatrixElementBridge.updateFilterMap(filterElement, filter, filterMap);
        return filter;
    }

    protected static float[][] convertValuesToMatrix(Element filterElement, BridgeContext ctx) {
        int n;
        String s2 = filterElement.getAttributeNS(null, "values");
        float[][] matrix = new float[4][5];
        if (s2.length() == 0) {
            matrix[0][0] = 1.0f;
            matrix[1][1] = 1.0f;
            matrix[2][2] = 1.0f;
            matrix[3][3] = 1.0f;
            return matrix;
        }
        StringTokenizer tokens = new StringTokenizer(s2, " ,");
        try {
            for (n = 0; n < 20 && tokens.hasMoreTokens(); ++n) {
                matrix[n / 5][n % 5] = SVGUtilities.convertSVGNumber(tokens.nextToken());
            }
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"values", s2, nfEx});
        }
        if (n != 20 || tokens.hasMoreTokens()) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"values", s2});
        }
        for (int i = 0; i < 4; ++i) {
            float[] fArray = matrix[i];
            fArray[4] = fArray[4] * 255.0f;
        }
        return matrix;
    }

    protected static float convertValuesToSaturate(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "values");
        if (s2.length() == 0) {
            return 1.0f;
        }
        try {
            return SVGUtilities.convertSVGNumber(s2);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"values", s2});
        }
    }

    protected static float convertValuesToHueRotate(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "values");
        if (s2.length() == 0) {
            return 0.0f;
        }
        try {
            return (float)Math.toRadians(SVGUtilities.convertSVGNumber(s2));
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"values", s2});
        }
    }

    protected static int convertType(Element filterElement, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, "type");
        if (s2.length() == 0) {
            return 0;
        }
        if ("hueRotate".equals(s2)) {
            return 2;
        }
        if ("luminanceToAlpha".equals(s2)) {
            return 3;
        }
        if ("matrix".equals(s2)) {
            return 0;
        }
        if ("saturate".equals(s2)) {
            return 1;
        }
        throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{"type", s2});
    }
}

