/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class BatikStarElementBridge
extends SVGDecoratedShapeElementBridge
implements BatikExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "star";
    }

    public Bridge getInstance() {
        return new BatikStarElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        String s2 = e.getAttributeNS(null, "cx");
        float cx = 0.0f;
        if (s2.length() != 0) {
            cx = UnitProcessor.svgHorizontalCoordinateToUserSpace(s2, "cx", uctx);
        }
        s2 = e.getAttributeNS(null, "cy");
        float cy = 0.0f;
        if (s2.length() != 0) {
            cy = UnitProcessor.svgVerticalCoordinateToUserSpace(s2, "cy", uctx);
        }
        if ((s2 = e.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(ctx, e, "attribute.missing", new Object[]{"r", s2});
        }
        float r = UnitProcessor.svgOtherLengthToUserSpace(s2, "r", uctx);
        s2 = e.getAttributeNS(null, "ir");
        if (s2.length() == 0) {
            throw new BridgeException(ctx, e, "attribute.missing", new Object[]{"ir", s2});
        }
        float ir = UnitProcessor.svgOtherLengthToUserSpace(s2, "ir", uctx);
        int sides = BatikStarElementBridge.convertSides(e, "sides", 3, ctx);
        GeneralPath gp = new GeneralPath();
        double SECTOR = Math.PI * 2 / (double)sides;
        double HALF_PI = 1.5707963267948966;
        for (int i = 0; i < sides; ++i) {
            double angle = (double)i * SECTOR - 1.5707963267948966;
            double x = (double)cx + (double)ir * Math.cos(angle);
            double y = (double)cy - (double)ir * Math.sin(angle);
            if (i == 0) {
                gp.moveTo((float)x, (float)y);
            } else {
                gp.lineTo((float)x, (float)y);
            }
            angle = ((double)i + 0.5) * SECTOR - 1.5707963267948966;
            x = (double)cx + (double)r * Math.cos(angle);
            y = (double)cy - (double)r * Math.sin(angle);
            gp.lineTo((float)x, (float)y);
        }
        gp.closePath();
        shapeNode.setShape(gp);
    }

    protected static int convertSides(Element filterElement, String attrName, int defaultValue, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, attrName);
        if (s2.length() == 0) {
            return defaultValue;
        }
        int ret = 0;
        try {
            ret = SVGUtilities.convertSVGInteger(s2);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{attrName, s2});
        }
        if (ret < 3) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{attrName, s2});
        }
        return ret;
    }
}

