/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.DataURIResolver;
import org.apache.xmlgraphics.util.io.Base64EncodeStream;

public class FOURIResolver
implements URIResolver {
    private Log log = LogFactory.getLog("FOP");
    private URIResolver dataURIResolver = new DataURIResolver();
    private URIResolver uriResolver = null;
    private boolean throwExceptions = false;

    public FOURIResolver() {
        this(false);
    }

    public FOURIResolver(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    private void handleException(Exception e, String errorStr, boolean strict) throws TransformerException {
        if (strict) {
            throw new TransformerException(errorStr, e);
        }
        this.log.error(e.getMessage());
    }

    public Source resolve(String href, String base) throws TransformerException {
        Source source = null;
        source = this.dataURIResolver.resolve(href, base);
        if (source == null && this.uriResolver != null) {
            source = this.uriResolver.resolve(href, base);
        }
        if (source == null) {
            URL absoluteURL;
            block26: {
                String fragment;
                String fileURL;
                absoluteURL = null;
                int hashPos = href.indexOf(35);
                if (hashPos >= 0) {
                    fileURL = href.substring(0, hashPos);
                    fragment = href.substring(hashPos);
                } else {
                    fileURL = href;
                    fragment = null;
                }
                File file = new File(fileURL);
                if (file.canRead() && file.isFile()) {
                    try {
                        if (fragment != null) {
                            absoluteURL = new URL(file.toURL().toExternalForm() + fragment);
                            break block26;
                        }
                        absoluteURL = file.toURL();
                    }
                    catch (MalformedURLException mfue) {
                        this.handleException(mfue, "Could not convert filename '" + href + "' to URL", this.throwExceptions);
                    }
                } else if (base == null) {
                    try {
                        absoluteURL = new URL(href);
                    }
                    catch (MalformedURLException mue) {
                        try {
                            absoluteURL = new URL("file:" + href);
                        }
                        catch (MalformedURLException mfue) {
                            this.handleException(mfue, "Error with URL '" + href + "'", this.throwExceptions);
                        }
                    }
                } else {
                    URL baseURL = null;
                    try {
                        baseURL = new URL(base);
                    }
                    catch (MalformedURLException mfue) {
                        this.handleException(mfue, "Error with base URL '" + base + "'", this.throwExceptions);
                    }
                    String scheme = baseURL.getProtocol() + ":";
                    if (href.startsWith(scheme)) {
                        href = href.substring(scheme.length());
                        if ("file:".equals(scheme)) {
                            int colonPos = href.indexOf(58);
                            int slashPos = href.indexOf(47);
                            if (slashPos >= 0 && colonPos >= 0 && colonPos < slashPos) {
                                href = "/" + href;
                            }
                        }
                    }
                    try {
                        absoluteURL = new URL(baseURL, href);
                    }
                    catch (MalformedURLException mfue) {
                        this.handleException(mfue, "Error with URL; base '" + base + "' " + "href '" + href + "'", this.throwExceptions);
                    }
                }
            }
            if (absoluteURL != null) {
                String effURL = absoluteURL.toExternalForm();
                try {
                    URLConnection connection = absoluteURL.openConnection();
                    connection.setAllowUserInteraction(false);
                    connection.setDoInput(true);
                    this.updateURLConnection(connection, href);
                    connection.connect();
                    return new StreamSource(connection.getInputStream(), effURL);
                }
                catch (FileNotFoundException fnfe) {
                    this.log.debug("File not found: " + effURL);
                }
                catch (IOException ioe) {
                    this.log.error("Error with opening URL '" + effURL + "': " + ioe.getMessage());
                }
            }
        }
        return source;
    }

    protected void updateURLConnection(URLConnection connection, String href) {
    }

    protected void applyHttpBasicAuthentication(URLConnection connection, String username, String password) {
        String combined = username + ":" + password;
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream(combined.length() * 2);
            Base64EncodeStream base64 = new Base64EncodeStream(baout);
            base64.write(combined.getBytes("UTF-8"));
            base64.close();
            connection.setRequestProperty("Authorization", "Basic " + new String(baout.toByteArray(), "UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error during base64 encodation of username/password");
        }
    }

    public void setCustomURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getCustomURIResolver() {
        return this.uriResolver;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }
}

