/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;

public class TableCellLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private static Log log;
    private PrimaryGridUnit primaryGridUnit;
    private Block curBlockArea;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int totalHeight;
    private int usedBPD;
    private int borderAndPaddingBPD;
    private boolean emptyCell = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableCellLayoutManager(TableCell node, PrimaryGridUnit pgu) {
        super(node);
        this.fobj = node;
        this.primaryGridUnit = pgu;
    }

    public TableCell getTableCell() {
        return (TableCell)this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.getTable().isSeparateBorderModel();
    }

    public void initialize() {
        this.borderAndPaddingBPD = 0;
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getBorderAfterWidth(false);
        if (!this.isSeparateBorderModel()) {
            this.borderAndPaddingBPD /= 2;
        }
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getPaddingBefore(false, this);
        this.borderAndPaddingBPD += this.getTableCell().getCommonBorderPaddingBackground().getPaddingAfter(false, this);
    }

    public Table getTable() {
        return this.getTableCell().getTable();
    }

    protected int getIPIndents() {
        int[] startEndBorderWidths = this.primaryGridUnit.getStartEndBorderWidths();
        this.startIndent = startEndBorderWidths[0];
        this.endIndent = startEndBorderWidths[1];
        if (this.isSeparateBorderModel()) {
            int borderSep = this.getTable().getBorderSeparation().getLengthPair().getIPD().getLength().getValue(this);
            this.startIndent += borderSep / 2;
            this.endIndent += borderSep / 2;
        } else {
            this.startIndent /= 2;
            this.endIndent /= 2;
        }
        this.startIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
        this.endIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingEnd(false, this);
        return this.startIndent + this.endIndent;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        MinOptMax stackLimit = new MinOptMax(context.getStackLimitBP());
        this.cellIPD = this.referenceIPD = context.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        LinkedList returnedList = null;
        LinkedList<BreakElement> contentList = new LinkedList<BreakElement>();
        LinkedList<KnuthBox> returnList = new LinkedList<KnuthBox>();
        BlockLevelLayoutManager prevLM = null;
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimitBP(MinOptMax.subtract(context.getStackLimitBP(), stackLimit));
            childLC.setRefIPD(this.cellIPD);
            returnedList = curLM.getNextKnuthElements(childLC, alignment);
            if (childLC.isKeepWithNextPending()) {
                log.debug("child LM signals pending keep with next");
            }
            if (contentList.size() == 0 && childLC.isKeepWithPreviousPending()) {
                this.primaryGridUnit.setKeepWithPrevious();
                childLC.setFlags(1024, false);
            }
            if (prevLM != null) {
                if (this.mustKeepTogether() || context.isKeepWithNextPending() || childLC.isKeepWithPreviousPending()) {
                    context.setFlags(512, false);
                    childLC.setFlags(1024, false);
                    contentList.add(new BreakElement(new Position(this), 1000, context));
                } else if (!(((ListElement)contentList.getLast()).isGlue() || ((ListElement)contentList.getLast()).isPenalty() && ((KnuthPenalty)contentList.getLast()).getP() < 1000 || contentList.getLast() instanceof BreakElement && ((BreakElement)contentList.getLast()).getPenaltyValue() < 1000)) {
                    contentList.add(new BreakElement(new Position(this), 0, context));
                }
            }
            contentList.addAll(returnedList);
            if (returnedList.size() == 0) continue;
            if (childLC.isKeepWithNextPending()) {
                childLC.setFlags(512, false);
                context.setFlags(512);
            }
            prevLM = curLM;
        }
        if (context.isKeepWithNextPending()) {
            this.primaryGridUnit.setKeepWithNext();
        }
        returnedList = new LinkedList();
        if (contentList.size() > 0) {
            this.wrapPositionElements(contentList, returnList);
        } else {
            returnList.add(new KnuthBox(0, this.notifyPos(new Position(this)), true));
        }
        SpaceResolver.resolveElementList(returnList);
        if (((KnuthElement)returnList.getFirst()).isForcedBreak()) {
            this.primaryGridUnit.setBreakBefore(((KnuthPenalty)returnList.getFirst()).getBreakClass());
            returnList.removeFirst();
            if (!$assertionsDisabled && returnList.isEmpty()) {
                throw new AssertionError();
            }
        }
        if (((KnuthElement)returnList.getLast()).isForcedBreak()) {
            KnuthPenalty p = (KnuthPenalty)returnList.getLast();
            this.primaryGridUnit.setBreakAfter(p.getBreakClass());
            p.setP(0);
        }
        this.getPSLM().notifyEndOfLayout(((TableCell)this.getFObj()).getId());
        this.setFinished(true);
        return returnList;
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    public void setXOffset(int off) {
        this.xoffset = off;
    }

    public void setContentHeight(int h2) {
        this.usedBPD = h2;
    }

    public void setTotalHeight(int h2) {
        this.totalHeight = h2;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext, int[] spannedGridRowHeights, int startRow, int endRow, int borderBeforeWhich, int borderAfterWhich, boolean firstOnPage, boolean lastOnPage, RowPainter painter, int firstRowHeight) {
        int paddingRectBPD;
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.getTableCell().getId());
        int borderBeforeWidth = this.primaryGridUnit.getBeforeBorderWidth(startRow, borderBeforeWhich);
        int borderAfterWidth = this.primaryGridUnit.getAfterBorderWidth(endRow, borderAfterWhich);
        CommonBorderPaddingBackground padding = this.primaryGridUnit.getCell().getCommonBorderPaddingBackground();
        int cellBPD = paddingRectBPD = this.totalHeight - borderBeforeWidth - borderAfterWidth;
        cellBPD -= padding.getPaddingBefore(borderBeforeWhich == 2, this);
        cellBPD -= padding.getPaddingAfter(borderAfterWhich == 2, this);
        this.addBackgroundAreas(painter, firstRowHeight, borderBeforeWidth, paddingRectBPD);
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                if (borderBeforeWidth > 0) {
                    int halfBorderSepBPD = this.getTableCell().getTable().getBorderSeparation().getBPD().getLength().getValue() / 2;
                    TableCellLayoutManager.adjustYOffset(this.curBlockArea, halfBorderSepBPD);
                }
                TraitSetter.addBorders(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), borderBeforeWidth == 0, borderAfterWidth == 0, false, false, this);
            }
        } else {
            boolean inLastColumn;
            boolean inFirstColumn = this.primaryGridUnit.getColIndex() == 0;
            boolean bl = inLastColumn = this.primaryGridUnit.getColIndex() + this.getTableCell().getNumberColumnsSpanned() == this.getTable().getNumberOfColumns();
            if (!this.primaryGridUnit.hasSpanning()) {
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, -borderBeforeWidth);
                boolean[] outer = new boolean[]{firstOnPage, lastOnPage, inFirstColumn, inLastColumn};
                TraitSetter.addCollapsingBorders(this.curBlockArea, this.primaryGridUnit.getBorderBefore(borderBeforeWhich), this.primaryGridUnit.getBorderAfter(borderAfterWhich), this.primaryGridUnit.getBorderStart(), this.primaryGridUnit.getBorderEnd(), outer);
            } else {
                int borderWidth;
                CommonBorderPaddingBackground.BorderInfo border;
                GridUnit gu;
                int x;
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, borderBeforeWidth);
                Block[][] blocks = new Block[this.getTableCell().getNumberRowsSpanned()][this.getTableCell().getNumberColumnsSpanned()];
                GridUnit[] gridUnits = (GridUnit[])this.primaryGridUnit.getRows().get(startRow);
                for (x = 0; x < this.getTableCell().getNumberColumnsSpanned(); ++x) {
                    gu = gridUnits[x];
                    border = gu.getBorderBefore(borderBeforeWhich);
                    borderWidth = border.getRetainedWidth() / 2;
                    if (borderWidth <= 0) continue;
                    this.addBorder(blocks, startRow, x, Trait.BORDER_BEFORE, border, firstOnPage);
                    TableCellLayoutManager.adjustYOffset(blocks[startRow][x], -borderWidth);
                    TableCellLayoutManager.adjustBPD(blocks[startRow][x], -borderWidth);
                }
                gridUnits = (GridUnit[])this.primaryGridUnit.getRows().get(endRow);
                for (x = 0; x < this.getTableCell().getNumberColumnsSpanned(); ++x) {
                    gu = gridUnits[x];
                    border = gu.getBorderAfter(borderAfterWhich);
                    borderWidth = border.getRetainedWidth() / 2;
                    if (borderWidth <= 0) continue;
                    this.addBorder(blocks, endRow, x, Trait.BORDER_AFTER, border, lastOnPage);
                    TableCellLayoutManager.adjustBPD(blocks[endRow][x], -borderWidth);
                }
                for (int y = startRow; y <= endRow; ++y) {
                    gridUnits = (GridUnit[])this.primaryGridUnit.getRows().get(y);
                    CommonBorderPaddingBackground.BorderInfo border2 = gridUnits[0].getBorderStart();
                    int borderWidth2 = border2.getRetainedWidth() / 2;
                    if (borderWidth2 > 0) {
                        this.addBorder(blocks, y, 0, Trait.BORDER_START, border2, inFirstColumn);
                        TableCellLayoutManager.adjustXOffset(blocks[y][0], borderWidth2);
                        TableCellLayoutManager.adjustIPD(blocks[y][0], -borderWidth2);
                    }
                    if ((borderWidth2 = (border2 = gridUnits[gridUnits.length - 1].getBorderEnd()).getRetainedWidth() / 2) <= 0) continue;
                    this.addBorder(blocks, y, gridUnits.length - 1, Trait.BORDER_END, border2, inLastColumn);
                    TableCellLayoutManager.adjustIPD(blocks[y][gridUnits.length - 1], -borderWidth2);
                }
                int dy = this.yoffset;
                for (int y = startRow; y <= endRow; ++y) {
                    int bpd = spannedGridRowHeights[y - startRow];
                    int dx = this.xoffset;
                    for (int x2 = 0; x2 < gridUnits.length; ++x2) {
                        int ipd = this.getTable().getColumn(this.primaryGridUnit.getColIndex() + x2).getColumnWidth().getValue(this.getParent());
                        if (blocks[y][x2] != null) {
                            Block block = blocks[y][x2];
                            TableCellLayoutManager.adjustYOffset(block, dy);
                            TableCellLayoutManager.adjustXOffset(block, dx);
                            TableCellLayoutManager.adjustIPD(block, ipd);
                            TableCellLayoutManager.adjustBPD(block, bpd);
                            this.parentLM.addChildArea(block);
                        }
                        dx += ipd;
                    }
                    dy += bpd;
                }
            }
        }
        TraitSetter.addPadding(this.curBlockArea, padding, borderBeforeWhich == 2, borderAfterWhich == 2, false, false, this);
        if (this.usedBPD < cellBPD) {
            if (this.getTableCell().getDisplayAlign() == 23) {
                Block space = new Block();
                space.setBPD((cellBPD - this.usedBPD) / 2);
                this.curBlockArea.addBlock(space);
            } else if (this.getTableCell().getDisplayAlign() == 3) {
                Block space = new Block();
                space.setBPD(cellBPD - this.usedBPD);
                this.curBlockArea.addBlock(space);
            }
        }
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.curBlockArea.setBPD(cellBPD);
        if (!this.isSeparateBorderModel() || !this.emptyCell || this.getTableCell().showEmptyCells()) {
            TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
        }
        this.flush();
        this.curBlockArea = null;
    }

    private void addBackgroundAreas(RowPainter painter, int firstRowHeight, int borderBeforeWidth, int paddingRectBPD) {
        TableRow row;
        TableBody body;
        TableColumn column = this.getTable().getColumn(this.primaryGridUnit.getColIndex());
        if (column.getCommonBorderPaddingBackground().hasBackground()) {
            Block colBackgroundArea = this.getBackgroundArea(paddingRectBPD, borderBeforeWidth);
            ((TableLayoutManager)this.parentLM).registerColumnBackgroundArea(column, colBackgroundArea, -this.startIndent);
        }
        if ((body = this.primaryGridUnit.getTableBody()).getCommonBorderPaddingBackground().hasBackground()) {
            painter.registerPartBackgroundArea(this.getBackgroundArea(paddingRectBPD, borderBeforeWidth));
        }
        if ((row = this.primaryGridUnit.getRow()) != null && row.getCommonBorderPaddingBackground().hasBackground()) {
            Block rowBackgroundArea = this.getBackgroundArea(paddingRectBPD, borderBeforeWidth);
            ((TableLayoutManager)this.parentLM).addBackgroundArea(rowBackgroundArea);
            TraitSetter.addBackground(rowBackgroundArea, row.getCommonBorderPaddingBackground(), (TableLayoutManager)this.parentLM, -this.xoffset - this.startIndent, -borderBeforeWidth, this.parentLM.getContentAreaIPD(), firstRowHeight);
        }
    }

    private void addBorder(Block[][] blocks, int i, int j, Integer side, CommonBorderPaddingBackground.BorderInfo border, boolean outer) {
        if (blocks[i][j] == null) {
            blocks[i][j] = new Block();
            blocks[i][j].addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            blocks[i][j].setPositioning(2);
        }
        blocks[i][j].addTrait(side, new BorderProps(border.getStyle(), border.getRetainedWidth(), border.getColor(), outer ? 2 : 1));
    }

    private static void adjustXOffset(Block block, int amount) {
        block.setXOffset(block.getXOffset() + amount);
    }

    private static void adjustYOffset(Block block, int amount) {
        block.setYOffset(block.getYOffset() + amount);
    }

    private static void adjustIPD(Block block, int amount) {
        block.setIPD(block.getIPD() + amount);
    }

    private static void adjustBPD(Block block, int amount) {
        block.setBPD(block.getBPD() + amount);
    }

    private Block getBackgroundArea(int bpd, int borderBeforeWidth) {
        CommonBorderPaddingBackground padding = this.getTableCell().getCommonBorderPaddingBackground();
        int paddingStart = padding.getPaddingStart(false, this);
        int paddingEnd = padding.getPaddingEnd(false, this);
        Block block = new Block();
        TraitSetter.setProducerID(block, this.getTable().getId());
        block.setPositioning(2);
        block.setIPD(this.cellIPD + paddingStart + paddingEnd);
        block.setBPD(bpd);
        block.setXOffset(this.xoffset + this.startIndent - paddingStart);
        block.setYOffset(this.yoffset + borderBeforeWidth);
        return block;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.curBlockArea, this.getTableCell().getId());
            this.curBlockArea.setPositioning(2);
            this.curBlockArea.setXOffset(this.xoffset + this.startIndent);
            this.curBlockArea.setYOffset(this.yoffset);
            this.curBlockArea.setIPD(this.cellIPD);
            this.parentLM.getParentArea(this.curBlockArea);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        boolean keep = ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
        if (this.primaryGridUnit.getRow() != null) {
            keep |= this.primaryGridUnit.getRow().mustKeepTogether();
        }
        return keep;
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }

    public int getContentAreaIPD() {
        return this.cellIPD;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error("getContentAreaBPD called on unknown BPD");
        return -1;
    }

    public boolean getGeneratesReferenceArea() {
        return true;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    static {
        $assertionsDisabled = !TableCellLayoutManager.class.desiredAssertionStatus();
        log = LogFactory.getLog(TableCellLayoutManager.class);
    }
}

