/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.render.AbstractFOEventHandlerMaker;
import org.apache.fop.render.AbstractRendererMaker;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;
import org.apache.xmlgraphics.util.Service;

public class RendererFactory {
    private static Log log = LogFactory.getLog(RendererFactory.class);
    private Map rendererMakerMapping = new HashMap();
    private Map eventHandlerMakerMapping = new HashMap();

    public RendererFactory() {
        this.discoverRenderers();
        this.discoverFOEventHandlers();
    }

    public void addRendererMaker(AbstractRendererMaker maker) {
        String[] mimes = maker.getSupportedMimeTypes();
        for (int i = 0; i < mimes.length; ++i) {
            if (this.rendererMakerMapping.get(mimes[i]) != null) {
                log.trace("Overriding renderer for " + mimes[i] + " with " + maker.getClass().getName());
            }
            this.rendererMakerMapping.put(mimes[i], maker);
        }
    }

    public void addFOEventHandlerMaker(AbstractFOEventHandlerMaker maker) {
        String[] mimes = maker.getSupportedMimeTypes();
        for (int i = 0; i < mimes.length; ++i) {
            if (this.eventHandlerMakerMapping.get(mimes[i]) != null) {
                log.trace("Overriding FOEventHandler for " + mimes[i] + " with " + maker.getClass().getName());
            }
            this.eventHandlerMakerMapping.put(mimes[i], maker);
        }
    }

    public void addRendererMaker(String className) {
        try {
            AbstractRendererMaker makerInstance = (AbstractRendererMaker)Class.forName(className).newInstance();
            this.addRendererMaker(makerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + className);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + className);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + className);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(className + " is not an " + AbstractRendererMaker.class.getName());
        }
    }

    public void addFOEventHandlerMaker(String className) {
        try {
            AbstractFOEventHandlerMaker makerInstance = (AbstractFOEventHandlerMaker)Class.forName(className).newInstance();
            this.addFOEventHandlerMaker(makerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + className);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + className);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + className);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(className + " is not an " + AbstractFOEventHandlerMaker.class.getName());
        }
    }

    public AbstractRendererMaker getRendererMaker(String mime) {
        AbstractRendererMaker maker = (AbstractRendererMaker)this.rendererMakerMapping.get(mime);
        return maker;
    }

    public AbstractFOEventHandlerMaker getFOEventHandlerMaker(String mime) {
        AbstractFOEventHandlerMaker maker = (AbstractFOEventHandlerMaker)this.eventHandlerMakerMapping.get(mime);
        return maker;
    }

    public Renderer createRenderer(FOUserAgent userAgent, String outputFormat) throws FOPException {
        if (userAgent.getRendererOverride() != null) {
            return userAgent.getRendererOverride();
        }
        AbstractRendererMaker maker = this.getRendererMaker(outputFormat);
        if (maker == null) {
            throw new UnsupportedOperationException("No renderer for the requested format available: " + outputFormat);
        }
        Renderer rend = maker.makeRenderer(userAgent);
        rend.setUserAgent(userAgent);
        RendererConfigurator configurator = maker.getConfigurator(userAgent);
        if (configurator != null) {
            configurator.configure(rend);
        }
        return rend;
    }

    public FOEventHandler createFOEventHandler(FOUserAgent userAgent, String outputFormat, OutputStream out) throws FOPException {
        if (userAgent.getFOEventHandlerOverride() != null) {
            return userAgent.getFOEventHandlerOverride();
        }
        AbstractFOEventHandlerMaker maker = this.getFOEventHandlerMaker(outputFormat);
        if (maker == null) {
            AbstractRendererMaker rendMaker = this.getRendererMaker(outputFormat);
            if (rendMaker == null && userAgent.getRendererOverride() == null) {
                throw new UnsupportedOperationException("Don't know how to handle \"" + outputFormat + "\" as an output format." + " Neither an FOEventHandler, nor a Renderer could be found" + " for this output format.");
            }
            if (out == null && userAgent.getRendererOverride() == null && rendMaker.needsOutputStream()) {
                throw new FOPException("OutputStream has not been set");
            }
            return new AreaTreeHandler(userAgent, outputFormat, out);
        }
        return maker.makeFOEventHandler(userAgent, out);
    }

    public String[] listSupportedMimeTypes() {
        ArrayList<String> lst = new ArrayList<String>();
        Iterator iter = this.rendererMakerMapping.keySet().iterator();
        while (iter.hasNext()) {
            lst.add((String)iter.next());
        }
        iter = this.eventHandlerMakerMapping.keySet().iterator();
        while (iter.hasNext()) {
            lst.add((String)iter.next());
        }
        Collections.sort(lst);
        return lst.toArray(new String[lst.size()]);
    }

    private void discoverRenderers() {
        Iterator providers = Service.providers(Renderer.class);
        if (providers != null) {
            while (providers.hasNext()) {
                AbstractRendererMaker maker = (AbstractRendererMaker)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding maker for Renderer: " + maker.getClass().getName());
                    }
                    this.addRendererMaker(maker);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding maker for Renderer", e);
                }
            }
        }
    }

    private void discoverFOEventHandlers() {
        Iterator providers = Service.providers(FOEventHandler.class);
        if (providers != null) {
            while (providers.hasNext()) {
                AbstractFOEventHandlerMaker maker = (AbstractFOEventHandlerMaker)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding maker for FOEventHandler: " + maker.getClass().getName());
                    }
                    this.addFOEventHandlerMaker(maker);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding maker for FOEventHandler", e);
                }
            }
        }
    }
}

