/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro.snippet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class SnippetReader {
    private static final String EOL = System.getProperty("line.separator");
    private URL source;
    private String encoding;

    public SnippetReader(URL src, String encoding) {
        this.source = src;
        this.encoding = encoding;
    }

    public SnippetReader(URL src) {
        this(src, null);
    }

    public StringBuffer readSnippet(String snippetId) throws IOException {
        List<String> lines = this.readLines(snippetId);
        int minIndent = this.minIndent(lines);
        StringBuffer result = new StringBuffer();
        for (String line : lines) {
            result.append(line.substring(minIndent));
            result.append(EOL);
        }
        return result;
    }

    int minIndent(List<String> lines) {
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            minIndent = Math.min(minIndent, this.indent(line));
        }
        return minIndent;
    }

    int indent(String line) {
        int indent;
        char[] chars = line.toCharArray();
        for (indent = 0; indent < chars.length && chars[indent] == ' '; ++indent) {
        }
        return indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(String snippetId) throws IOException {
        BufferedReader reader = this.encoding == null || "".equals(this.encoding) ? new BufferedReader(new InputStreamReader(this.source.openStream())) : new BufferedReader(new InputStreamReader(this.source.openStream(), this.encoding));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            boolean capture = false;
            boolean foundStart = false;
            boolean foundEnd = false;
            boolean hasSnippetId = StringUtils.isNotEmpty(snippetId);
            while ((line = reader.readLine()) != null) {
                if (!hasSnippetId) {
                    lines.add(line);
                    continue;
                }
                if (this.isStart(snippetId, line)) {
                    capture = true;
                    foundStart = true;
                    continue;
                }
                if (this.isEnd(snippetId, line)) {
                    foundEnd = true;
                    break;
                }
                if (!capture) continue;
                lines.add(line);
            }
            if (hasSnippetId && !foundStart) {
                throw new IOException("Failed to find START of snippet " + snippetId + " in file at URL: " + this.source);
            }
            if (hasSnippetId && !foundEnd) {
                throw new IOException("Failed to find END of snippet " + snippetId + " in file at URL: " + this.source);
            }
        }
        finally {
            IOUtil.close(reader);
        }
        return lines;
    }

    protected boolean isStart(String snippetId, String line) {
        return SnippetReader.isDemarcator(snippetId, "START", line);
    }

    protected static boolean isDemarcator(String snippetId, String what, String line) {
        String snippetRegExp = "(^|\\W)(?i:SNIPPET)($|\\W)";
        String snippetIdRegExp = "(^|\\W)" + snippetId + "($|\\W)";
        String whatRegExp = "(^|\\W)(?i:" + what + ")($|\\W)";
        return Pattern.compile(snippetRegExp).matcher(line).find() && Pattern.compile(whatRegExp).matcher(line).find() && Pattern.compile(snippetIdRegExp).matcher(line).find();
    }

    protected boolean isEnd(String snippetId, String line) {
        return SnippetReader.isDemarcator(snippetId, "END", line);
    }
}

