/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.pipeline;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.impl.CompositeImageLoader;
import org.apache.xmlgraphics.image.loader.pipeline.ImageConversionEdge;
import org.apache.xmlgraphics.image.loader.pipeline.ImageProviderPipeline;
import org.apache.xmlgraphics.image.loader.pipeline.ImageRepresentation;
import org.apache.xmlgraphics.image.loader.spi.ImageConverter;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;
import org.apache.xmlgraphics.image.loader.spi.ImageLoaderFactory;
import org.apache.xmlgraphics.util.dijkstra.DefaultEdgeDirectory;
import org.apache.xmlgraphics.util.dijkstra.DijkstraAlgorithm;
import org.apache.xmlgraphics.util.dijkstra.Vertex;

public class PipelineFactory {
    protected static Log log = LogFactory.getLog(PipelineFactory.class);
    private ImageManager manager;
    private int converterEdgeDirectoryVersion = -1;
    private DefaultEdgeDirectory converterEdgeDirectory;

    public PipelineFactory(ImageManager manager) {
        this.manager = manager;
    }

    private DefaultEdgeDirectory getEdgeDirectory() {
        ImageImplRegistry registry = this.manager.getRegistry();
        if (registry.getImageConverterModifications() != this.converterEdgeDirectoryVersion) {
            Collection converters = registry.getImageConverters();
            DefaultEdgeDirectory dir = new DefaultEdgeDirectory();
            Iterator iter = converters.iterator();
            while (iter.hasNext()) {
                ImageConverter converter = (ImageConverter)iter.next();
                dir.addEdge(new ImageConversionEdge(converter));
            }
            this.converterEdgeDirectoryVersion = registry.getImageConverterModifications();
            this.converterEdgeDirectory = dir;
        }
        return this.converterEdgeDirectory;
    }

    public ImageProviderPipeline newImageConverterPipeline(Image originalImage, ImageFlavor targetFlavor) {
        DefaultEdgeDirectory dir = this.getEdgeDirectory();
        ImageRepresentation destination = new ImageRepresentation(targetFlavor);
        ImageProviderPipeline pipeline = this.findPipeline(dir, originalImage.getFlavor(), destination);
        return pipeline;
    }

    public ImageProviderPipeline newImageConverterPipeline(ImageInfo imageInfo, ImageFlavor targetFlavor) {
        String originalMime = imageInfo.getMimeType();
        ImageImplRegistry registry = this.manager.getRegistry();
        ImageProviderPipeline pipeline = null;
        DefaultEdgeDirectory dir = this.getEdgeDirectory();
        ImageLoaderFactory[] loaderFactories = registry.getImageLoaderFactories(imageInfo, targetFlavor);
        if (loaderFactories != null) {
            ImageLoader loader;
            if (loaderFactories.length == 1) {
                loader = loaderFactories[0].newImageLoader(targetFlavor);
            } else {
                int count = loaderFactories.length;
                ImageLoader[] loaders = new ImageLoader[count];
                for (int i = 0; i < count; ++i) {
                    loaders[i] = loaderFactories[i].newImageLoader(targetFlavor);
                }
                loader = new CompositeImageLoader(loaders);
            }
            pipeline = new ImageProviderPipeline(this.manager.getCache(), loader);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("No ImageLoaderFactory found that can load this format directly. Trying ImageConverters instead...");
            }
            ImageRepresentation destination = new ImageRepresentation(targetFlavor);
            loaderFactories = registry.getImageLoaderFactories(originalMime);
            if (loaderFactories != null) {
                TreeSet<ImageProviderPipeline> candidates = new TreeSet<ImageProviderPipeline>(new PipelineComparator());
                int ci = loaderFactories.length;
                for (int i = 0; i < ci; ++i) {
                    ImageLoaderFactory loaderFactory = loaderFactories[i];
                    ImageFlavor[] flavors = loaderFactory.getSupportedFlavors(originalMime);
                    int cj = flavors.length;
                    for (int j = 0; j < cj; ++j) {
                        pipeline = this.findPipeline(dir, flavors[j], destination);
                        if (pipeline == null) continue;
                        ImageLoader loader = loaderFactory.newImageLoader(flavors[j]);
                        pipeline.setImageLoader(loader);
                        candidates.add(pipeline);
                    }
                }
                if (candidates.size() > 0) {
                    pipeline = (ImageProviderPipeline)candidates.first();
                }
            }
        }
        if (pipeline != null && log.isDebugEnabled()) {
            log.debug("Pipeline: " + pipeline + " with penalty " + pipeline.getConversionPenalty());
        }
        return pipeline;
    }

    private ImageProviderPipeline findPipeline(DefaultEdgeDirectory dir, ImageFlavor originFlavor, ImageRepresentation destination) {
        DijkstraAlgorithm dijkstra = new DijkstraAlgorithm(dir);
        ImageRepresentation origin = new ImageRepresentation(originFlavor);
        dijkstra.execute(origin, destination);
        if (log.isTraceEnabled()) {
            log.trace("Lowest penalty: " + dijkstra.getLowestPenalty(destination));
        }
        Vertex prev = destination;
        Vertex pred = dijkstra.getPredecessor(destination);
        if (pred == null) {
            if (log.isTraceEnabled()) {
                log.trace("No route found!");
            }
            return null;
        }
        LinkedList<ImageConversionEdge> stops = new LinkedList<ImageConversionEdge>();
        while ((pred = dijkstra.getPredecessor(prev)) != null) {
            ImageConversionEdge edge = (ImageConversionEdge)dir.getBestEdge(pred, prev);
            stops.addFirst(edge);
            prev = pred;
        }
        ImageProviderPipeline pipeline = new ImageProviderPipeline(this.manager.getCache(), null);
        Iterator iter = stops.iterator();
        while (iter.hasNext()) {
            ImageConversionEdge edge = (ImageConversionEdge)iter.next();
            pipeline.addConverter(edge.getImageConverter());
        }
        return pipeline;
    }

    public ImageProviderPipeline[] determineCandidatePipelines(ImageInfo imageInfo, ImageFlavor[] flavors) {
        int count = flavors.length;
        ImageProviderPipeline[] candidates = new ImageProviderPipeline[count];
        for (int i = 0; i < count; ++i) {
            candidates[i] = this.newImageConverterPipeline(imageInfo, flavors[i]);
        }
        return candidates;
    }

    public ImageProviderPipeline[] determineCandidatePipelines(Image sourceImage, ImageFlavor[] flavors) {
        int count = flavors.length;
        ImageProviderPipeline[] candidates = new ImageProviderPipeline[count];
        for (int i = 0; i < count; ++i) {
            candidates[i] = this.newImageConverterPipeline(sourceImage, flavors[i]);
        }
        return candidates;
    }

    private static class PipelineComparator
    implements Comparator {
        private PipelineComparator() {
        }

        public int compare(Object o1, Object o2) {
            ImageProviderPipeline p1 = (ImageProviderPipeline)o1;
            ImageProviderPipeline p2 = (ImageProviderPipeline)o2;
            return p1.getConversionPenalty() - p2.getConversionPenalty();
        }
    }
}

