/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlSignature;
import org.openmuc.jsml.structures.SmlValue;

public class SmlValueEntry
extends Sequence {
    private SmlValue value;
    private SmlSignature valueSignature;

    public SmlValueEntry(SmlValue value, SmlSignature valueSignature) {
        this.value = value;
        this.valueSignature = valueSignature;
        if (this.valueSignature == null) {
            this.valueSignature = new SmlSignature();
        }
        this.setOptionalAndSeq();
        this.setSelected(true);
    }

    public void setOptionalAndSeq() {
        this.valueSignature.setOptional();
        this.seqArray(this.value, this.valueSignature);
    }

    @Override
    protected void createElements() {
        this.value = new SmlValue();
        this.valueSignature = new SmlSignature();
        this.setOptionalAndSeq();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  SML_ValueEntry{\n");
        sb.append("    value:    " + this.value.toString() + "\n");
        sb.append("    valueSignature:   " + this.valueSignature.toString() + "\n");
        sb.append("  }\n");
        return sb.toString();
    }

    public SmlValue getValue() {
        return this.value;
    }

    public SmlSignature getValueSignature() {
        return this.valueSignature;
    }

    public void setValue(SmlValue value) {
        this.value = value;
    }

    public void setValueSignature(SmlSignature valueSignature) {
        this.valueSignature = valueSignature;
    }

    public SmlValueEntry() {
    }
}

