/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures.requests;

import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlTree;
import org.openmuc.jsml.structures.SmlTreePath;

public class SmlSetProcParameterReq
extends Sequence {
    protected OctetString serverId;
    protected OctetString username;
    protected OctetString password;
    protected SmlTreePath parameterTreePath;
    protected SmlTree parameterTree;

    public SmlSetProcParameterReq() {
    }

    public SmlSetProcParameterReq(OctetString serverId, OctetString username, OctetString password, SmlTreePath parameterTreePath, SmlTree parameterTree) {
        if (parameterTreePath == null) {
            throw new IllegalArgumentException("SML_SetProcParameterReq: parameterTreePath is not optional and must not be null!");
        }
        if (parameterTree == null) {
            throw new IllegalArgumentException("SML_SetProcParameterReq: parameterTree is not optional and must not be null!");
        }
        this.serverId = serverId;
        this.username = username;
        this.password = password;
        this.parameterTreePath = parameterTreePath;
        this.parameterTree = parameterTree;
        if (serverId == null) {
            this.serverId = new OctetString();
        }
        if (username == null) {
            this.username = new OctetString();
        }
        if (password == null) {
            this.password = new OctetString();
        }
        this.setOptionalAndSeq();
        this.setSelected(true);
    }

    public OctetString getServerId() {
        return this.serverId;
    }

    public OctetString getUsername() {
        return this.username;
    }

    public OctetString getPassword() {
        return this.password;
    }

    public SmlTreePath getParameterTreePath() {
        return this.parameterTreePath;
    }

    public SmlTree getParameterTree() {
        return this.parameterTree;
    }

    public void setOptionalAndSeq() {
        this.serverId.setOptional();
        this.username.setOptional();
        this.password.setOptional();
        this.seqArray(this.serverId, this.username, this.password, this.parameterTreePath, this.parameterTree);
    }

    @Override
    protected void createElements() {
        this.serverId = new OctetString();
        this.username = new OctetString();
        this.password = new OctetString();
        this.parameterTreePath = new SmlTreePath();
        this.parameterTree = new SmlTree();
        this.setOptionalAndSeq();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sml_SetProcParameterReq{\n");
        sb.append("  serverId:          " + this.serverId.toString() + "\n");
        sb.append("  username:          " + this.username.toString() + "\n");
        sb.append("  password:          " + this.password.toString() + "\n");
        sb.append("  parameterTreePath: " + this.parameterTreePath.toString() + "\n");
        sb.append("}\n");
        return sb.toString();
    }
}

