/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import com.hastobe.transparenzsoftware.gui.listeners.SelectBoxChangedListener;
import com.hastobe.transparenzsoftware.gui.views.MainView;
import com.hastobe.transparenzsoftware.gui.views.customelements.EncodingTypePanel;
import com.hastobe.transparenzsoftware.gui.views.customelements.ErrorLog;
import com.hastobe.transparenzsoftware.gui.views.customelements.MainViewErrorPanel;
import com.hastobe.transparenzsoftware.gui.views.customelements.VerifyTextArea;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RawDataPanel
extends JPanel {
    private static final String TEXT_RAW_DATA = "app.view.dataset";
    private static final String TEXT_PUBLIC_KEY = "app.public.key";
    public static final String PASTE_FROM_CLIPBOARD_ACTION = "paste-from-clipboard";
    private final VerifyTextArea rawDataField;
    private final MainViewErrorPanel errorPanel;
    private final EncodingTypePanel encodingTypePanel;
    private AtomicBoolean eventsEnabled = new AtomicBoolean();

    public RawDataPanel(MainView mainView) {
        this.setLayout(new BorderLayout(20, 20));
        this.rawDataField = new VerifyTextArea(mainView, this.eventsEnabled);
        JScrollPane scrollRawData = new JScrollPane(this.getRawDataField());
        this.add((Component)scrollRawData, "Center");
        this.getRawDataField().setName("text.rawdata");
        ErrorLog eLog = new ErrorLog();
        eLog.setName("lbl.elog");
        this.errorPanel = new MainViewErrorPanel(eLog);
        this.encodingTypePanel = new EncodingTypePanel(new SelectBoxChangedListener(mainView));
        this.add((Component)this.encodingTypePanel, "South");
        this.getRawDataField().setEnabled(false);
    }

    public void setErrorMessage(String message) {
        this.add((Component)this.errorPanel, "South");
        this.errorPanel.setErrorText(message, false);
    }

    public void setWarningMessage(String message) {
        this.add(this.errorPanel);
        this.errorPanel.setErrorText(message, true);
    }

    public void clearErrorMessage() {
        this.remove(this.errorPanel);
        this.errorPanel.setErrorText("", true);
        this.repaint();
        this.revalidate();
        this.updateUI();
    }

    public void clearInputs() {
        this.getRawDataField().setText("");
        this.getRawDataField().setEnabled(false);
    }

    public String getRawDataContent() {
        return this.getRawDataField().getText();
    }

    public void cleanUpNoiseInRawData() {
        String data = this.getRawDataField().getText();
        data = data.replaceAll("\n", " ");
        data = data.replaceAll("\t", " ");
        data = data.trim();
        this.getRawDataField().setText(data);
    }

    public void fillUpContent(String rawDataContent, EncodingType encoding, VerificationType type) {
        if (rawDataContent == null) {
            rawDataContent = "";
        }
        if (encoding == null) {
            encoding = EncodingType.PLAIN;
        }
        if (type == null) {
            type = VerificationType.EDL_40_P;
        }
        this.encodingTypePanel.setVerificationType(type);
        this.encodingTypePanel.setEncoding(encoding);
        this.getRawDataField().setText(rawDataContent);
    }

    public boolean isErrorMessageSet() {
        return this.errorPanel.isErrorMessageSet();
    }

    public VerifyTextArea getRawDataField() {
        return this.rawDataField;
    }

    public VerificationType getVerificationType() {
        return this.encodingTypePanel.getVerificationType();
    }

    public EncodingType getEncoding() {
        return this.encodingTypePanel.getEncoding();
    }

    public void setEncoding(EncodingType encodingType) {
        this.encodingTypePanel.setEncoding(encodingType);
    }

    public void setVerificationType(VerificationType verificationType) {
        this.encodingTypePanel.setVerificationType(verificationType);
    }
}

