/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import com.hastobe.transparenzsoftware.gui.views.helper.NodeHeadingHolder;
import com.hastobe.transparenzsoftware.gui.views.helper.NodeValueHolder;
import com.hastobe.transparenzsoftware.gui.views.helper.ValueIndexHolder;
import com.hastobe.transparenzsoftware.gui.views.helper.ValueMapBuilder;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.input.InvalidInputException;
import com.hastobe.transparenzsoftware.verification.xml.Values;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ValueTree
extends JTree {
    private TreeNode[] pathMinimumTransactionId;
    private Map<BigInteger, List<ValueIndexHolder>> transactionMap;
    private final List<NodeValueHolder> values;

    public ValueTree(TreeNode treeNode, List<NodeValueHolder> values, Map<BigInteger, List<ValueIndexHolder>> transactionMap, DefaultMutableTreeNode treeNodeMininumTransactionId) {
        super(treeNode);
        this.values = values;
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        renderer.setLeafIcon(null);
        this.setRootVisible(false);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        this.toggleTree(true);
        this.getSelectionModel().setSelectionMode(1);
        this.transactionMap = transactionMap;
        this.setExpandsSelectedPaths(true);
        TreeModel model = this.getModel();
        if (model instanceof DefaultTreeModel) {
            DefaultTreeModel dfModel = (DefaultTreeModel)model;
            this.pathMinimumTransactionId = dfModel.getPathToRoot(treeNodeMininumTransactionId);
        }
    }

    public static ValueTree createFromValues(Values values) throws InvalidInputException {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        Map<BigInteger, List<ValueIndexHolder>> transactionMap = ValueMapBuilder.buildTransactionMap(values);
        ArrayList<NodeValueHolder> valueHolders = new ArrayList<NodeValueHolder>();
        DefaultMutableTreeNode pathMinimumTransactionId = null;
        BigInteger minimumTransactionId = BigInteger.valueOf(Long.MAX_VALUE);
        int indexTransactions = 0;
        for (BigInteger transactionId : transactionMap.keySet()) {
            String label = Translator.get("app.view.no.transactionid");
            if (!transactionId.equals(ValueMapBuilder.NO_TRANSACTION_KEY)) {
                label = String.format("%s %d", Translator.get("app.view.transaction.id"), transactionId);
            }
            DefaultMutableTreeNode transactionRootNode = new DefaultMutableTreeNode(label);
            if (!transactionId.equals(ValueMapBuilder.NO_TRANSACTION_KEY)) {
                NodeHeadingHolder headingHolder = new NodeHeadingHolder(transactionId, label);
                transactionRootNode.setUserObject(headingHolder);
                if (minimumTransactionId.longValue() > transactionId.longValue()) {
                    pathMinimumTransactionId = transactionRootNode;
                    minimumTransactionId = transactionId;
                }
            }
            int i = 0;
            for (ValueIndexHolder value : transactionMap.get(transactionId)) {
                DefaultMutableTreeNode valueNode = new DefaultMutableTreeNode("node");
                NodeValueHolder holder = new NodeValueHolder(value, i, valueNode);
                valueHolders.add(holder);
                valueNode.setUserObject(holder);
                transactionRootNode.add(valueNode);
                ++i;
            }
            root.add(transactionRootNode);
            ++indexTransactions;
        }
        ValueTree tree = new ValueTree(root, valueHolders, transactionMap, pathMinimumTransactionId);
        return tree;
    }

    public void toggleTree(boolean expand) {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        this.toggleAll(new TreePath(root), expand);
    }

    public void toggleAll(TreePath path, boolean expand) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                TreeNode n = enumeration.nextElement();
                TreePath p = path.pathByAddingChild(n);
                this.toggleAll(p, expand);
            }
        }
        if (expand) {
            this.expandPath(path);
        } else {
            this.collapsePath(path);
        }
    }

    public void selectValue(int index) {
        for (NodeValueHolder value : this.values) {
            if (value.getValue().getInitIndex() != index) continue;
            this.setSelectionPath(new TreePath(value.getValueNode().getPath()));
        }
    }

    public Map<BigInteger, List<ValueIndexHolder>> getTransactionMap() {
        return this.transactionMap;
    }

    public TreeNode[] getPathMinimumTransactionId() {
        return this.pathMinimumTransactionId;
    }
}

