/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.ocmf;

public class OBISCode {
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;
    private int F;

    public int getA() {
        return this.A;
    }

    public int getB() {
        return this.B;
    }

    public int getC() {
        return this.C;
    }

    public int getD() {
        return this.D;
    }

    public int getE() {
        return this.E;
    }

    public int getF() {
        return this.F;
    }

    private boolean isHex(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f';
    }

    private int handleHex(char ch, int before) {
        return before << 4 | (ch >= 'a' ? ch - 97 + 10 : ch - 48) & 0xF;
    }

    public OBISCode(String code) {
        code = code.toLowerCase().trim();
        int state = 0;
        block8: for (int i = 0; i < code.length(); ++i) {
            char ch = code.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '-') {
                        state = 1;
                        continue block8;
                    }
                    if (this.isHex(ch)) {
                        this.A = this.handleHex(ch, this.A);
                        continue block8;
                    }
                    throw new IllegalArgumentException("OBIS code " + code + " can not be parsed.");
                }
                case 1: {
                    if (ch == ':') {
                        state = 2;
                        continue block8;
                    }
                    if (this.isHex(ch)) {
                        this.B = this.handleHex(ch, this.B);
                        continue block8;
                    }
                    throw new IllegalArgumentException("OBIS code " + code + " can not be parsed.");
                }
                case 2: {
                    if (ch == '.') {
                        state = 3;
                        continue block8;
                    }
                    if (this.isHex(ch)) {
                        this.C = this.handleHex(ch, this.C);
                        continue block8;
                    }
                    throw new IllegalArgumentException("OBIS code " + code + " can not be parsed.");
                }
                case 3: {
                    if (ch == '.') {
                        state = 4;
                        continue block8;
                    }
                    if (this.isHex(ch)) {
                        this.D = this.handleHex(ch, this.D);
                        continue block8;
                    }
                    throw new IllegalArgumentException("OBIS code " + code + " can not be parsed.");
                }
                case 4: {
                    if (ch == '.' || ch == '*') {
                        state = 5;
                        continue block8;
                    }
                    if (this.isHex(ch)) {
                        this.E = this.handleHex(ch, this.E);
                        continue block8;
                    }
                    throw new IllegalArgumentException("OBIS code " + code + " can not be parsed.");
                }
                case 5: {
                    if (this.isHex(ch)) {
                        this.F = this.handleHex(ch, this.F);
                        continue block8;
                    }
                    throw new IllegalArgumentException("OBIS code " + code + " can not be parsed.");
                }
            }
        }
    }

    public String toString() {
        return "" + this.A + "-" + this.B + ":" + this.C + "." + this.D + "." + this.E + "." + this.F;
    }
}

