/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.ocmf;

import com.hastobe.transparenzsoftware.gui.views.helper.DetailsList;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.FormatComparisonException;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.ocmf.OBISCode;
import com.hastobe.transparenzsoftware.verification.format.ocmf.OCMF;
import com.hastobe.transparenzsoftware.verification.format.ocmf.OCMFPayloadData;
import com.hastobe.transparenzsoftware.verification.format.ocmf.OCMFValidationException;
import com.hastobe.transparenzsoftware.verification.format.ocmf.Reading;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.VerifiedData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OCMFVerifiedData
extends VerifiedData {
    private String publicKey;
    private String encoding;
    private String formatVersion;
    private String vendorIdentification;
    private String vendorVersion;
    private String pagination;
    private String meterVendor;
    private String meterModel;
    private String meterSerialNumber;
    private String meterFirmwareVersion;
    private String identificationStatus;
    private String identificationLevel;
    private String identificationFlags;
    private String identificationType;
    private String identificationData;
    private List<Meter> meters;
    private OCMFPayloadData ocmfPayloadData;

    public OCMFVerifiedData() {
    }

    public OCMFVerifiedData(OCMF ocmf, String publicKey, String encoding) {
        if (ocmf == null) {
            return;
        }
        this.ocmfPayloadData = ocmf.getData();
        this.meters = new ArrayList<Meter>();
        for (Reading reading : this.ocmfPayloadData.getRD()) {
            Double rv;
            Meter.Type type = null;
            int digits = reading.getRVDigits();
            if (reading.isStartTransaction()) {
                type = Meter.Type.START;
            }
            if (reading.isStopTransaction()) {
                type = Meter.Type.STOP;
            }
            if ((rv = reading.getRV()) != null && reading.getRU() != null && reading.getRU().trim().toLowerCase().equals("wh")) {
                rv = rv / 1000.0;
                digits -= 3;
            }
            if (rv == null) {
                rv = 0.0;
            }
            Meter.TimeSyncType timeSyncType = reading.getTimeSyncType();
            Meter m3 = new Meter(rv, reading.getTimestamp(), type, timeSyncType, digits);
            m3.setLawRelevant(this.isLawRelevant(reading));
            this.meters.add(m3);
        }
        this.publicKey = publicKey;
        this.encoding = encoding;
        this.formatVersion = this.ocmfPayloadData.getFV();
        this.vendorIdentification = this.ocmfPayloadData.getGI();
        this.vendorVersion = this.ocmfPayloadData.getGV();
        this.pagination = this.ocmfPayloadData.getPG();
        this.meterVendor = this.ocmfPayloadData.getMV();
        this.meterModel = this.ocmfPayloadData.getMM();
        this.meterSerialNumber = this.ocmfPayloadData.getMS();
        this.meterFirmwareVersion = this.ocmfPayloadData.getMF();
        this.identificationStatus = this.ocmfPayloadData.getIdStatus();
        this.identificationLevel = this.ocmfPayloadData.getIdLevel();
        if (this.ocmfPayloadData.getIF() != null) {
            this.identificationFlags = String.join((CharSequence)", ", this.ocmfPayloadData.getIF());
        }
        this.identificationType = this.ocmfPayloadData.getIT();
        this.identificationData = this.ocmfPayloadData.getID();
    }

    @Override
    public List<Meter> getMeters() {
        return this.meters;
    }

    @Override
    public String getFormat() {
        return VerificationType.OCMF.name();
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public DetailsList getAdditionalData() {
        DetailsList addData = new DetailsList();
        addData.put(Translator.get("app.verify.ocmf.version"), this.getFormatVersion());
        addData.put(Translator.get("app.verify.ocmf.vendorIdentifier"), this.getVendorIdentification());
        addData.put(Translator.get("app.verify.ocmf.vendorVersion"), this.getVendorVersion());
        addData.put(Translator.get("app.verify.ocmf.pagination"), this.getPagination());
        if (this.getMeterVendor() != null) {
            addData.put(Translator.get("app.verify.ocmf.meterVendor"), this.getMeterVendor());
        }
        if (this.getMeterModel() != null) {
            addData.put(Translator.get("app.verify.ocmf.meterModel"), this.getMeterModel());
        }
        if (this.getMeterSerialNumber() != null) {
            addData.put(Translator.get("app.verify.ocmf.meterSerialNumber"), this.getMeterSerialNumber());
        }
        if (this.getMeterFirmwareVersion() != null) {
            addData.put(Translator.get("app.verify.ocmf.meterFirmwareVersion"), this.getMeterFirmwareVersion());
        }
        if (this.getIdentificationStatus() != null) {
            addData.put(Translator.get("app.verify.ocmf.identificationStatus"), this.getIdentificationStatus());
        }
        if (this.getIdentificationLevel() != null) {
            addData.put(Translator.get("app.verify.ocmf.identificationLevel"), this.getIdentificationLevel());
        }
        if (this.getIdentificationFlags() != null) {
            addData.put(Translator.get("app.verify.ocmf.identificationFlags"), this.getIdentificationFlags());
        }
        if (this.getIdentificationType() != null) {
            addData.put(Translator.get("app.verify.ocmf.identificationType"), this.getIdentificationType());
        }
        if (this.getIdentificationData() != null) {
            addData.put(Translator.get("app.verify.ocmf.identificationData"), this.getIdentificationData());
        }
        if (this.ocmfPayloadData.getRD() != null) {
            int count = 1;
            for (Reading reading : this.ocmfPayloadData.getRD()) {
                String time = reading.getTM() != null ? reading.getTM() : "-";
                String val = time + " " + reading.getRV() + " " + reading.getRU();
                addData.put(Translator.get("app.view.single.value") + " " + count, val);
                if (reading.getTimeSynchronicity() != null) {
                    String label = Translator.get("app.verify.ocmf.timesynchronicity");
                    addData.put(String.format("%s %s", label, count), Translator.get(reading.getLabelForTimeFlag()));
                }
                ++count;
            }
            addData.put(Translator.get("app.verify.ocmf.identificationData"), this.getIdentificationData());
        }
        return addData;
    }

    @Override
    public boolean lawConform(VerifiedData stopValue) throws RegulationLawException, ValidationException {
        if (!(stopValue instanceof OCMFVerifiedData)) {
            throw new FormatComparisonException();
        }
        if (this.getMeters() == null) {
            throw new OCMFValidationException("OCMF entry marked as start does not contain any meter values", "app.verify.ocmf.startcontainsnometers");
        }
        if (stopValue.getMeters() == null) {
            throw new OCMFValidationException("OCMF entry marked ast stop does not contain any meter values", "app.verify.ocmf.stopcontainsnometers");
        }
        OCMFVerifiedData otherOCMFData = (OCMFVerifiedData)stopValue;
        boolean stopContainsStart = stopValue.getMeters().stream().anyMatch(meter -> meter.getType() != null && meter.getType().equals((Object)Meter.Type.START));
        if (stopContainsStart) {
            throw new OCMFValidationException("OCMF entry marked as stop contains a start value", "app.verify.ocmf.stopcontainsstart");
        }
        boolean startContainsStop = this.getMeters().stream().anyMatch(meter -> meter.getType() != null && meter.getType().equals((Object)Meter.Type.STOP));
        if (startContainsStop) {
            throw new OCMFValidationException("OCMF entry marked as start contains a stop value", "app.verify.ocmf.startcontainsstop");
        }
        ArrayList<Reading> combinedReadings = new ArrayList<Reading>();
        combinedReadings.addAll(this.ocmfPayloadData.getRD());
        combinedReadings.addAll(otherOCMFData.ocmfPayloadData.getRD());
        return this.checkLawIntegrityForReadings(combinedReadings, this.ocmfPayloadData.getIdLevel(), otherOCMFData.ocmfPayloadData.getIdLevel());
    }

    public boolean checkLawIntegrityForTransaction() throws ValidationException, RegulationLawException {
        return this.checkLawIntegrityForReadings(this.ocmfPayloadData.getRD(), this.ocmfPayloadData.getIdLevel(), null);
    }

    private boolean checkLawIntegrityForReadings(List<? extends Reading> readings, String idLevelStart, String idLevelStop) throws OCMFValidationException, RegulationLawException {
        Reading startValue = null;
        Reading stopValue = null;
        String previousST = null;
        String previousRU = null;
        for (Reading reading : readings) {
            if (!this.isLawRelevant(reading)) continue;
            if (reading.getST() == null) {
                if (previousST == null) {
                    throw new OCMFValidationException("Missing mandatory ST parameter for first reading.", "error.values.missing.st");
                }
                reading.setST(previousST);
            } else {
                previousST = reading.getST();
            }
            if (reading.getRU() == null) {
                if (previousRU == null) {
                    throw new OCMFValidationException("Missing mandatory RU parameter for first reading.", "error.values.missing.ru");
                }
                reading.setRU(previousRU);
            } else {
                previousRU = reading.getRU();
            }
            if (reading.isStartTransaction()) {
                if (startValue != null) {
                    throw new OCMFValidationException("Cannot verify contains multiple start values", "error.values.toomany.start");
                }
                startValue = reading;
            }
            if (!reading.isStopTransaction()) continue;
            if (stopValue != null) {
                throw new OCMFValidationException("Cannot verify contains multiple stop values", "error.values.toomany.stop");
            }
            stopValue = reading;
        }
        if (startValue == null) {
            throw new OCMFValidationException("Cannot verify contains no start values in reading", "error.values.no.start.meter.values");
        }
        if (stopValue == null) {
            throw new OCMFValidationException("Cannot verify contains no stop values in readings", "error.values.no.stop.meter.values");
        }
        if (startValue.getRV() > stopValue.getRV()) {
            throw new RegulationLawException("Meter value of start is higher than meter value of stop", "app.verify.law.conform.meter.wrong");
        }
        if (startValue.getTimestamp() != null && stopValue.getTimestamp() != null && startValue.getTimestamp().isAfter(stopValue.getTimestamp())) {
            throw new RegulationLawException("Meter timestamp of start is after timestamp of stop", "app.verify.law.conform.meter.time.wrong");
        }
        List<String> contractStatusErrors = Arrays.asList("MISMATCH", "INVALID", "OUTDATED", "UNKNOWN");
        if (idLevelStart != null && contractStatusErrors.contains(idLevelStart.trim())) {
            throw new RegulationLawException("Error on reading contract id", "app.verify.law.conform.timesynchronicity.wrong");
        }
        if (idLevelStop != null && contractStatusErrors.contains(idLevelStop.trim())) {
            throw new RegulationLawException("Error on reading contract id", "app.verify.law.conform.timesynchronicity.wrong");
        }
        if (startValue.getST() == null || !startValue.getST().equals("G") || !stopValue.getST().equals("G")) {
            throw new RegulationLawException("Meter error code present", "app.verify.law.conform.meterstatus.wrong");
        }
        if (startValue.getTimeSynchronicity() == null || startValue.getTimeSynchronicity().equals("R") && !stopValue.getTimeSynchronicity().equals("R")) {
            throw new RegulationLawException("Time synchronicity wrong", "app.verify.law.conform.timesynchronicity.wrong");
        }
        if (stopValue.getEI() != null && !stopValue.getEI().equals(startValue.getEI())) {
            throw new RegulationLawException("Event counter of start and stop differs", "app.verify.law.conform.eventcounter.differs");
        }
        this.checkErrorFlag(startValue);
        this.checkErrorFlag(stopValue);
        return true;
    }

    private boolean isLawRelevant(Reading reading) {
        String ri = reading.getRI();
        if (ri == null) {
            return false;
        }
        try {
            OBISCode obis = new OBISCode(ri);
            if (obis.getA() == 1 && obis.getC() == 1 && obis.getD() == 8) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void checkErrorFlag(Reading startValue) throws RegulationLawException {
        if (startValue.getEF() != null) {
            if (startValue.getEF().equals("E")) {
                throw new RegulationLawException("Error flag set on energy", "app.verify.law.conform.error.flag.energy");
            }
            if (startValue.getEF().equals("t")) {
                throw new RegulationLawException("Error flag set on time", "app.verify.law.conform.error.flag.time");
            }
        }
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getVendorIdentification() {
        return this.vendorIdentification;
    }

    public String getVendorVersion() {
        return this.vendorVersion;
    }

    public String getPagination() {
        return this.pagination;
    }

    public String getMeterVendor() {
        return this.meterVendor;
    }

    public String getMeterModel() {
        return this.meterModel;
    }

    public String getMeterSerialNumber() {
        return this.meterSerialNumber;
    }

    public String getMeterFirmwareVersion() {
        return this.meterFirmwareVersion;
    }

    public String getIdentificationStatus() {
        return this.identificationStatus;
    }

    public String getIdentificationFlags() {
        return this.identificationFlags;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public String getIdentificationData() {
        return this.identificationData;
    }

    public String getIdentificationLevel() {
        return this.identificationLevel;
    }

    public boolean containsCompleteTransaction() {
        return this.ocmfPayloadData.containsCompleteTransaction();
    }
}

