/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.result;

import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;

public class Error {
    protected String message;
    protected Type type;
    private final String localizedMessageCode;

    public Error(Type errorType, String message, String localizedMessageCode) {
        this.message = message;
        this.type = errorType;
        this.localizedMessageCode = localizedMessageCode;
    }

    public static Error withValidationException(ValidationException e) {
        return new Error(Type.VALIDATION, e.getMessage(), e.getLocalizedMessageKey());
    }

    public static Error withRegulationLawException(RegulationLawException e) {
        return new Error(Type.VERIFICATION, e.getMessage(), e.getLocalizedMessageKey());
    }

    public static Error withVerificationFailed() {
        return new Error(Type.VERIFICATION, "Verification failed", "error.verification.failed");
    }

    public static Error withDecodingPublicKeyFailed() {
        return new Error(Type.INPUT, "no encoding found for key", "error.values.publickey.cannot.encode");
    }

    public static Error withDecodingSignatureFailed() {
        return new Error(Type.INPUT, "no encoding found for signature", "error.values.signature.cannot.encode");
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizedMessageCode() {
        return this.localizedMessageCode;
    }

    public Type getType() {
        return this.type;
    }

    public String getLocalizedMessage() {
        return Translator.get(this.localizedMessageCode);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Error)) {
            return false;
        }
        Error otherError = (Error)other;
        return this.type.equals((Object)otherError.type) && this.getMessage().equals(((Error)other).getMessage());
    }

    public String toString() {
        return String.format("Type %s: %s", new Object[]{this.type, this.message});
    }

    public static enum Type {
        INPUT,
        VALIDATION,
        VERIFICATION;

    }
}

