/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class RtfStylesheetList
extends RtfElement
implements RtfExtendedElement {
    private HashMap styleMap = new HashMap();
    private boolean defaultsLoaded = false;

    public RtfStylesheetList(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        RtfParagraphStyle rtfParagraphStyle2 = new RtfParagraphStyle(this.document, rtfParagraphStyle);
        rtfParagraphStyle2.setStyleNumber(this.styleMap.size());
        rtfParagraphStyle2.handleInheritance();
        this.styleMap.put(rtfParagraphStyle2.getStyleName(), rtfParagraphStyle2);
    }

    private void registerDefaultStyles() {
        this.defaultsLoaded = true;
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_NORMAL.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_NORMAL);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_1.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_1);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_2.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_2);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_3.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_3);
        }
    }

    public RtfParagraphStyle getRtfParagraphStyle(String string) {
        if (!this.defaultsLoaded) {
            this.registerDefaultStyles();
        }
        if (this.styleMap.containsKey(string)) {
            return (RtfParagraphStyle)this.styleMap.get(string);
        }
        return null;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write("{".getBytes());
            byteArrayOutputStream.write("\\stylesheet".getBytes());
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                byteArrayOutputStream.write("\n".getBytes());
            }
            Iterator iterator = this.styleMap.values().iterator();
            while (iterator.hasNext()) {
                byteArrayOutputStream.write(((RtfParagraphStyle)iterator.next()).writeDefinition());
            }
            byteArrayOutputStream.write("}".getBytes());
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                byteArrayOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

