/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.Color;
import java.util.NoSuchElementException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class FOText
extends FONode {
    public char[] ca;
    public int startIndex = 0;
    public int endIndex = 0;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private Color color;
    private KeepProperty keepTogether;
    private Property letterSpacing;
    private SpaceProperty lineHeight;
    private int whiteSpaceTreatment;
    private int whiteSpaceCollapse;
    private int textTransform;
    private Property wordSpacing;
    private int wrapOption;
    private Length baselineShift;
    private FOText prevFOTextThisBlock = null;
    private FOText nextFOTextThisBlock = null;
    private Block ancestorBlock = null;
    private CommonTextDecoration textDecoration;
    private static final int IS_WORD_CHAR_FALSE = 0;
    private static final int IS_WORD_CHAR_TRUE = 1;
    private static final int IS_WORD_CHAR_MAYBE = 2;

    public FOText(FONode parent) {
        super(parent);
    }

    protected void addCharacters(char[] data, int start, int end, PropertyList list, Locator locator) throws FOPException {
        int length = end - start;
        int calength = 0;
        char[] nca = null;
        if (this.ca != null) {
            calength = this.ca.length;
            nca = new char[calength + length];
            System.arraycopy(this.ca, 0, nca, 0, calength);
        } else {
            nca = new char[length];
        }
        System.arraycopy(data, start, nca, calength, length);
        this.endIndex = nca.length;
        this.ca = nca;
    }

    public FONode clone(FONode parent, boolean removeChildren) throws FOPException {
        FOText ft = (FOText)super.clone(parent, removeChildren);
        if (removeChildren && this.ca != null) {
            ft.ca = new char[this.ca.length];
            System.arraycopy(this.ca, 0, ft.ca, 0, this.ca.length);
        }
        ft.prevFOTextThisBlock = null;
        ft.nextFOTextThisBlock = null;
        ft.ancestorBlock = null;
        return ft;
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonFont = pList.getFontProps();
        this.commonHyphenation = pList.getHyphenationProps();
        this.color = pList.get(66).getColor(this.getUserAgent());
        this.keepTogether = pList.get(118).getKeep();
        this.lineHeight = pList.get(131).getSpace();
        this.letterSpacing = pList.get(128);
        this.whiteSpaceCollapse = pList.get(239).getEnum();
        this.whiteSpaceTreatment = pList.get(240).getEnum();
        this.textTransform = pList.get(230).getEnum();
        this.wordSpacing = pList.get(243);
        this.wrapOption = pList.get(244).getEnum();
        this.textDecoration = pList.getTextDecorationProps();
        this.baselineShift = pList.get(15).getLength();
    }

    protected void endOfNode() throws FOPException {
        this.textTransform();
        this.getFOEventHandler().characters(this.ca, this.startIndex, this.endIndex);
    }

    public boolean willCreateArea() {
        if (this.whiteSpaceCollapse == 48 && this.endIndex - this.startIndex > 0) {
            return true;
        }
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            char ch = this.ca[i];
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
            return true;
        }
        return false;
    }

    public CharIterator charIterator() {
        return new TextCharIterator();
    }

    protected void createBlockPointers(Block ancestorBlock) {
        this.ancestorBlock = ancestorBlock;
        if (ancestorBlock.lastFOTextProcessed != null) {
            if (ancestorBlock.lastFOTextProcessed.ancestorBlock == this.ancestorBlock) {
                this.prevFOTextThisBlock = ancestorBlock.lastFOTextProcessed;
                this.prevFOTextThisBlock.nextFOTextThisBlock = this;
            } else {
                this.prevFOTextThisBlock = null;
            }
        }
    }

    private void textTransform() {
        if (this.getFOEventHandler().inMarker() || this.textTransform == 95) {
            return;
        }
        for (int i = 0; i < this.endIndex; ++i) {
            this.ca[i] = this.charTransform(i);
        }
    }

    private boolean isStartOfWord(int i) {
        char prevChar = this.getRelativeCharInBlock(i, -1);
        switch (FOText.isWordChar(prevChar)) {
            case 1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                char prevPrevChar = this.getRelativeCharInBlock(i, -2);
                switch (FOText.isWordChar(prevPrevChar)) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private char getRelativeCharInBlock(int i, int offset) {
        if (i + offset >= 0 && i + offset <= this.endIndex) {
            return this.ca[i + offset];
        }
        if (offset > 0) {
            return '\u0000';
        }
        boolean foundChar = false;
        char charToReturn = '\u0000';
        FOText nodeToTest = this;
        int remainingOffset = offset + i;
        while (!foundChar) {
            if (nodeToTest.prevFOTextThisBlock == null) {
                foundChar = true;
                break;
            }
            nodeToTest = nodeToTest.prevFOTextThisBlock;
            if (nodeToTest.endIndex + remainingOffset >= 0) {
                charToReturn = nodeToTest.ca[nodeToTest.endIndex + remainingOffset];
                foundChar = true;
                continue;
            }
            remainingOffset += nodeToTest.endIndex;
        }
        return charToReturn;
    }

    public FOText getPrevFOTextThisBlock() {
        return this.prevFOTextThisBlock;
    }

    public FOText getNextFOTextThisBlock() {
        return this.nextFOTextThisBlock;
    }

    public Block getAncestorBlock() {
        return this.ancestorBlock;
    }

    private char charTransform(int i) {
        switch (this.textTransform) {
            case 95: {
                return this.ca[i];
            }
            case 155: {
                return Character.toUpperCase(this.ca[i]);
            }
            case 78: {
                return Character.toLowerCase(this.ca[i]);
            }
            case 22: {
                if (this.isStartOfWord(i)) {
                    return Character.toTitleCase(this.ca[i]);
                }
                return this.ca[i];
            }
        }
        log.warn("Invalid text-tranform value: " + this.textTransform);
        return this.ca[i];
    }

    public static int isWordChar(char inputChar) {
        switch (Character.getType(inputChar)) {
            case 8: {
                return 1;
            }
            case 23: {
                return 1;
            }
            case 15: {
                return 0;
            }
            case 26: {
                return 1;
            }
            case 20: {
                if (inputChar == '-') {
                    return 1;
                }
                return 0;
            }
            case 9: {
                return 1;
            }
            case 7: {
                return 0;
            }
            case 22: {
                if (inputChar == '\u2019') {
                    return 2;
                }
                return 0;
            }
            case 16: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 13: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 25: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 27: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 24: {
                if (inputChar == '\'') {
                    return 2;
                }
                return 0;
            }
            case 28: {
                return 1;
            }
            case 14: {
                return 0;
            }
            case 18: {
                return 0;
            }
            case 12: {
                return 0;
            }
            case 21: {
                return 0;
            }
            case 19: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public Color getColor() {
        return this.color;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getWhitespaceTreatment() {
        return this.whiteSpaceTreatment;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public int getWrapOption() {
        return this.wrapOption;
    }

    public CommonTextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public Length getBaseLineShift() {
        return this.baselineShift;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" (").append(this.ca).append(")");
        return sb.toString();
    }

    public String getLocalName() {
        return null;
    }

    public String getNormalNamespacePrefix() {
        return null;
    }

    protected String gatherContextInfo() {
        if (this.getLocator() != null) {
            return super.gatherContextInfo();
        }
        return new String(this.ca).trim();
    }

    private class TextCharIterator
    extends CharIterator {
        private int curIndex = 0;
        private int nextCharCalled = 0;

        private TextCharIterator() {
        }

        public boolean hasNext() {
            if (this.curIndex == 0) {
                // empty if block
            }
            return this.curIndex < FOText.this.endIndex;
        }

        public char nextChar() {
            if (this.curIndex < FOText.this.endIndex) {
                ++this.nextCharCalled;
                return FOText.this.ca[this.curIndex++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.curIndex < FOText.this.endIndex && this.nextCharCalled < 2) {
                ++FOText.this.startIndex;
                this.nextCharCalled = 0;
            } else if (this.curIndex < FOText.this.endIndex) {
                System.arraycopy(FOText.this.ca, this.curIndex, FOText.this.ca, this.curIndex - 1, FOText.this.endIndex - this.curIndex);
                --FOText.this.endIndex;
                --this.curIndex;
            } else if (this.curIndex == FOText.this.endIndex) {
                --FOText.this.endIndex;
                --this.curIndex;
            }
        }

        public void replaceChar(char c) {
            if (this.curIndex > 0 && this.curIndex <= FOText.this.endIndex) {
                FOText.this.ca[this.curIndex - 1] = c;
            }
        }
    }
}

