/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fonts.Font;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;

public class TraitSetter {
    protected static Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void setBorderPaddingTraits(Area area, CommonBorderPaddingBackground bpProps, boolean bNotFirst, boolean bNotLast, PercentBaseContext context) {
        int iBP = bpProps.getPadding(2, bNotFirst, context);
        if (iBP > 0) {
            area.addTrait(Trait.PADDING_START, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(3, bNotLast, context)) > 0) {
            area.addTrait(Trait.PADDING_END, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(0, false, context)) > 0) {
            area.addTrait(Trait.PADDING_BEFORE, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(1, false, context)) > 0) {
            area.addTrait(Trait.PADDING_AFTER, new Integer(iBP));
        }
        TraitSetter.addBorderTrait(area, bpProps, bNotFirst, 2, 0, Trait.BORDER_START);
        TraitSetter.addBorderTrait(area, bpProps, bNotLast, 3, 0, Trait.BORDER_END);
        TraitSetter.addBorderTrait(area, bpProps, false, 0, 0, Trait.BORDER_BEFORE);
        TraitSetter.addBorderTrait(area, bpProps, false, 1, 0, Trait.BORDER_AFTER);
    }

    private static void addBorderTrait(Area area, CommonBorderPaddingBackground bpProps, boolean bDiscard, int iSide, int mode, Object oTrait) {
        int iBP = bpProps.getBorderWidth(iSide, bDiscard);
        if (iBP > 0) {
            area.addTrait(oTrait, new BorderProps(bpProps.getBorderStyle(iSide), iBP, bpProps.getBorderColor(iSide), mode));
        }
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground bordProps, PercentBaseContext context) {
        BorderProps bps = TraitSetter.getBorderProps(bordProps, 0);
        if (bps != null) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 1)) != null) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 2)) != null) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 3)) != null) {
            area.addTrait(Trait.BORDER_END, bps);
        }
        TraitSetter.addPadding(area, bordProps, context);
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground bordProps, boolean discardBefore, boolean discardAfter, boolean discardStart, boolean discardEnd, PercentBaseContext context) {
        BorderProps bps = TraitSetter.getBorderProps(bordProps, 0);
        if (bps != null && !discardBefore) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 1)) != null && !discardAfter) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 2)) != null && !discardStart) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 3)) != null && !discardEnd) {
            area.addTrait(Trait.BORDER_END, bps);
        }
    }

    public static void addCollapsingBorders(Area area, CommonBorderPaddingBackground.BorderInfo borderBefore, CommonBorderPaddingBackground.BorderInfo borderAfter, CommonBorderPaddingBackground.BorderInfo borderStart, CommonBorderPaddingBackground.BorderInfo borderEnd, boolean[] outer) {
        BorderProps bps = TraitSetter.getCollapsingBorderProps(borderBefore, outer[0]);
        if (bps != null) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(borderAfter, outer[1])) != null) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(borderStart, outer[2])) != null) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(borderEnd, outer[3])) != null) {
            area.addTrait(Trait.BORDER_END, bps);
        }
    }

    private static void addPadding(Area area, CommonBorderPaddingBackground bordProps, PercentBaseContext context) {
        TraitSetter.addPadding(area, bordProps, false, false, false, false, context);
    }

    public static void addPadding(Area area, CommonBorderPaddingBackground bordProps, boolean discardBefore, boolean discardAfter, boolean discardStart, boolean discardEnd, PercentBaseContext context) {
        int padding = bordProps.getPadding(0, discardBefore, context);
        if (padding != 0) {
            area.addTrait(Trait.PADDING_BEFORE, new Integer(padding));
        }
        if ((padding = bordProps.getPadding(1, discardAfter, context)) != 0) {
            area.addTrait(Trait.PADDING_AFTER, new Integer(padding));
        }
        if ((padding = bordProps.getPadding(2, discardStart, context)) != 0) {
            area.addTrait(Trait.PADDING_START, new Integer(padding));
        }
        if ((padding = bordProps.getPadding(3, discardEnd, context)) != 0) {
            area.addTrait(Trait.PADDING_END, new Integer(padding));
        }
    }

    private static BorderProps getBorderProps(CommonBorderPaddingBackground bordProps, int side) {
        int width = bordProps.getBorderWidth(side, false);
        if (width != 0) {
            BorderProps bps = new BorderProps(bordProps.getBorderStyle(side), width, bordProps.getBorderColor(side), 0);
            return bps;
        }
        return null;
    }

    private static BorderProps getCollapsingBorderProps(CommonBorderPaddingBackground.BorderInfo borderInfo, boolean outer) {
        if (!$assertionsDisabled && borderInfo == null) {
            throw new AssertionError();
        }
        int width = borderInfo.getRetainedWidth();
        if (width != 0) {
            BorderProps bps = new BorderProps(borderInfo.getStyle(), width, borderInfo.getColor(), outer ? 2 : 1);
            return bps;
        }
        return null;
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground backProps, PercentBaseContext context, int ipdShift, int bpdShift, int referenceIPD, int referenceBPD) {
        if (!backProps.hasBackground()) {
            return;
        }
        Trait.Background back = new Trait.Background();
        back.setColor(backProps.backgroundColor);
        if (backProps.getImageInfo() != null) {
            SimplePercentBaseContext refContext;
            back.setURL(backProps.backgroundImage);
            back.setImageInfo(backProps.getImageInfo());
            back.setRepeat(backProps.backgroundRepeat);
            if (backProps.backgroundPositionHorizontal != null && (back.getRepeat() == 96 || back.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    refContext = new SimplePercentBaseContext(context, 9, referenceIPD - back.getImageInfo().getSize().getWidthMpt());
                    back.setHoriz(ipdShift + backProps.backgroundPositionHorizontal.getValue(refContext));
                } else {
                    log.warn("Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (backProps.backgroundPositionVertical != null && (back.getRepeat() == 96 || back.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    refContext = new SimplePercentBaseContext(context, 10, referenceBPD - back.getImageInfo().getSize().getHeightMpt());
                    back.setVertical(bpdShift + backProps.backgroundPositionVertical.getValue(refContext));
                } else {
                    log.warn("Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, back);
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground backProps, PercentBaseContext context) {
        if (!backProps.hasBackground()) {
            return;
        }
        Trait.Background back = new Trait.Background();
        back.setColor(backProps.backgroundColor);
        if (backProps.getImageInfo() != null) {
            back.setURL(backProps.backgroundImage);
            back.setImageInfo(backProps.getImageInfo());
            back.setRepeat(backProps.backgroundRepeat);
            if (backProps.backgroundPositionHorizontal != null && (back.getRepeat() == 96 || back.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    int width = area.getIPD();
                    width += backProps.getPaddingStart(false, context);
                    back.setHoriz(backProps.backgroundPositionHorizontal.getValue(new SimplePercentBaseContext(context, 9, (width += backProps.getPaddingEnd(false, context)) - back.getImageInfo().getSize().getWidthMpt())));
                } else {
                    log.warn("Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (backProps.backgroundPositionVertical != null && (back.getRepeat() == 96 || back.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    int height = area.getBPD();
                    height += backProps.getPaddingBefore(false, context);
                    back.setVertical(backProps.backgroundPositionVertical.getValue(new SimplePercentBaseContext(context, 10, (height += backProps.getPaddingAfter(false, context)) - back.getImageInfo().getSize().getHeightMpt())));
                } else {
                    log.warn("Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, back);
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground bpProps, int startIndent, int endIndent, PercentBaseContext context) {
        int spaceEnd;
        int spaceStart;
        if (startIndent != 0) {
            area.addTrait(Trait.START_INDENT, new Integer(startIndent));
        }
        if ((spaceStart = startIndent - bpProps.getBorderStartWidth(false) - bpProps.getPaddingStart(false, context)) != 0) {
            area.addTrait(Trait.SPACE_START, new Integer(spaceStart));
        }
        if (endIndent != 0) {
            area.addTrait(Trait.END_INDENT, new Integer(endIndent));
        }
        if ((spaceEnd = endIndent - bpProps.getBorderEndWidth(false) - bpProps.getPaddingEnd(false, context)) != 0) {
            area.addTrait(Trait.SPACE_END, new Integer(spaceEnd));
        }
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground bpProps, CommonMarginBlock marginProps, PercentBaseContext context) {
        int startIndent = marginProps.startIndent.getValue(context);
        int endIndent = marginProps.endIndent.getValue(context);
        TraitSetter.addMargins(area, bpProps, startIndent, endIndent, context);
    }

    public static int getEffectiveSpace(double adjust, MinOptMax space) {
        if (space == null) {
            return 0;
        }
        int sp = space.opt;
        sp = adjust > 0.0 ? (sp += (int)(adjust * (double)(space.max - space.opt))) : (sp += (int)(adjust * (double)(space.opt - space.min)));
        return sp;
    }

    public static void addSpaceBeforeAfter(Area area, double adjust, MinOptMax spaceBefore, MinOptMax spaceAfter) {
        int space = TraitSetter.getEffectiveSpace(adjust, spaceBefore);
        if (space != 0) {
            area.addTrait(Trait.SPACE_BEFORE, new Integer(space));
        }
        if ((space = TraitSetter.getEffectiveSpace(adjust, spaceAfter)) != 0) {
            area.addTrait(Trait.SPACE_AFTER, new Integer(space));
        }
    }

    public static void addBreaks(Area area, int breakBefore, int breakAfter) {
    }

    public static void addFontTraits(Area area, Font font) {
        area.addTrait(Trait.FONT, font.getFontTriplet());
        area.addTrait(Trait.FONT_SIZE, new Integer(font.getFontSize()));
    }

    public static void addTextDecoration(Area area, CommonTextDecoration deco) {
        if (deco != null) {
            if (deco.hasUnderline()) {
                area.addTrait(Trait.UNDERLINE, Boolean.TRUE);
                area.addTrait(Trait.UNDERLINE_COLOR, deco.getUnderlineColor());
            }
            if (deco.hasOverline()) {
                area.addTrait(Trait.OVERLINE, Boolean.TRUE);
                area.addTrait(Trait.OVERLINE_COLOR, deco.getOverlineColor());
            }
            if (deco.hasLineThrough()) {
                area.addTrait(Trait.LINETHROUGH, Boolean.TRUE);
                area.addTrait(Trait.LINETHROUGH_COLOR, deco.getLineThroughColor());
            }
            if (deco.isBlinking()) {
                area.addTrait(Trait.BLINK, Boolean.TRUE);
            }
        }
    }

    public static void setProducerID(Area area, String id) {
        if (id != null && id.length() > 0) {
            area.addTrait(Trait.PROD_ID, id);
        }
    }

    static {
        $assertionsDisabled = !TraitSetter.class.desiredAssertionStatus();
        log = LogFactory.getLog(TraitSetter.class);
    }
}

