/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

public class PDFName
extends PDFObject {
    private String name;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PDFName(String name) {
        this.name = PDFName.escapeName(name);
    }

    private static String escapeName(String name) {
        StringBuffer sb = new StringBuffer(Math.min(16, name.length() + 4));
        if (!name.startsWith("/")) {
            sb.append('/');
        }
        int c = name.length();
        for (int i = 0; i < c; ++i) {
            char ch = name.charAt(i);
            if (ch >= '!' && ch <= '~') {
                sb.append(ch);
                continue;
            }
            sb.append('#');
            PDFName.toHex(ch, sb);
        }
        return sb.toString();
    }

    private static void toHex(char ch, StringBuffer sb) {
        if (ch >= '\u0100') {
            throw new IllegalArgumentException("Only 8-bit characters allowed by this implementation");
        }
        sb.append(DIGITS[ch >>> 4 & 0xF]);
        sb.append(DIGITS[ch & 0xF]);
    }

    public String toString() {
        return this.name;
    }

    protected int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        Writer writer = PDFDocument.getWriterFor(cout);
        if (this.hasObjectNumber()) {
            writer.write(this.getObjectID());
        }
        writer.write(this.toString());
        if (this.hasObjectNumber()) {
            writer.write("\nendobj\n");
        }
        writer.flush();
        return cout.getCount();
    }

    public void outputInline(OutputStream out, Writer writer) throws IOException {
        if (this.hasObjectNumber()) {
            writer.write(this.referencePDF());
        } else {
            writer.write(this.toString());
        }
    }
}

