/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.modca.AbstractPageObject;
import org.apache.fop.render.afp.modca.ActiveEnvironmentGroup;
import org.apache.fop.render.afp.modca.Document;
import org.apache.fop.render.afp.modca.ImageObject;
import org.apache.fop.render.afp.modca.Overlay;
import org.apache.fop.render.afp.modca.PageGroup;
import org.apache.fop.render.afp.modca.PageObject;
import org.apache.fop.render.afp.modca.TagLogicalElementBean;
import org.apache.fop.render.afp.tools.StringUtils;

public class AFPDataStream {
    protected static Log log = LogFactory.getLog("org.apache.fop.render.afp.modca");
    private boolean complete = false;
    private Document document = null;
    private PageGroup currentPageGroup = null;
    private PageObject currentPageObject = null;
    private Overlay currentOverlay = null;
    private AbstractPageObject currentPage = null;
    private int pageCount = 0;
    private int ovlCount = 0;
    private int portraitRotation = 0;
    private int landscapeRotation = 270;
    private int xOffset = 0;
    private int yOffset = 0;
    private int rotation;
    private OutputStream outputStream = null;

    public void startDocument(OutputStream docOutputStream) {
        if (this.document != null) {
            String msg = "Invalid state - document already started.";
            log.warn("startDocument():: " + msg);
            throw new IllegalStateException(msg);
        }
        this.document = new Document();
        this.outputStream = docOutputStream;
    }

    public void endDocument() throws IOException {
        if (this.complete) {
            String msg = "Invalid state - document already ended.";
            log.warn("endDocument():: " + msg);
            throw new IllegalStateException(msg);
        }
        if (this.currentPageObject != null) {
            this.endPage();
        }
        if (this.currentPageGroup != null) {
            this.endPageGroup();
        }
        this.document.endDocument();
        this.document.writeDataStream(this.outputStream);
        this.outputStream.flush();
        this.complete = true;
        this.document = null;
        this.outputStream = null;
    }

    public void startPage(int pageWidth, int pageHeight, int pageRotation, int pageWidthResolution, int pageHeightResolution) {
        String pageName = "PGN" + StringUtils.lpad(String.valueOf(this.pageCount++), '0', 5);
        this.currentPageObject = new PageObject(pageName, pageWidth, pageHeight, pageRotation, pageWidthResolution, pageHeightResolution);
        this.currentPage = this.currentPageObject;
        this.currentOverlay = null;
        this.setOffsets(0, 0, 0);
    }

    public void startOverlay(int overlayX, int overlayY, int overlayWidth, int overlayHeight, int overlayWidthResolution, int overlayHeightResolution, int overlayRotation) {
        String overlayName = "OVL" + StringUtils.lpad(String.valueOf(this.ovlCount++), '0', 5);
        this.currentOverlay = new Overlay(overlayName, overlayWidth, overlayHeight, overlayWidthResolution, overlayHeightResolution, overlayRotation);
        this.currentPageObject.addOverlay(this.currentOverlay);
        this.currentPageObject.createIncludePageOverlay(overlayName, overlayX, overlayY, 0);
        this.currentPage = this.currentOverlay;
        this.setOffsets(0, 0, 0);
    }

    public void endOverlay() {
        this.currentOverlay.endPage();
        this.currentOverlay = null;
        this.currentPage = this.currentPageObject;
    }

    public PageObject savePage() {
        PageObject pageObject = this.currentPageObject;
        if (this.currentPageGroup != null) {
            this.currentPageGroup.addPage(this.currentPageObject);
        } else {
            this.document.addPage(this.currentPageObject);
        }
        this.currentPageObject = null;
        this.currentPage = null;
        return pageObject;
    }

    public void restorePage(PageObject pageObject) {
        this.currentPageObject = pageObject;
        this.currentPage = pageObject;
    }

    public void endPage() throws IOException {
        this.currentPageObject.endPage();
        if (this.currentPageGroup != null) {
            this.currentPageGroup.addPage(this.currentPageObject);
        } else {
            this.document.addPage(this.currentPageObject);
            this.document.writeDataStream(this.outputStream);
        }
        this.currentPageObject = null;
        this.currentPage = null;
    }

    public void setOffsets(int xOff, int yOff, int rot) {
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.rotation = rot;
    }

    public void createFont(byte fontReference, AFPFont font, int size) {
        this.currentPage.createFont(fontReference, font, size);
    }

    public void createText(int fontNumber, int x, int y, Color col, int vsci, int ica, byte[] data) {
        this.currentPage.createText(fontNumber, x + this.xOffset, y + this.yOffset, this.rotation, col, vsci, ica, data);
    }

    public ImageObject getImageObject(int x, int y, int w, int h2, int wr, int hr) {
        int heightResolution;
        int widthResolution;
        int height;
        int width;
        int yOrigin;
        int xOrigin;
        switch (this.rotation) {
            case 90: {
                xOrigin = this.currentPage.getWidth() - y - this.yOffset;
                yOrigin = x + this.xOffset;
                width = h2;
                height = w;
                widthResolution = hr;
                heightResolution = wr;
                break;
            }
            case 180: {
                xOrigin = this.currentPage.getWidth() - x - this.xOffset;
                yOrigin = this.currentPage.getHeight() - y - this.yOffset;
                width = w;
                height = h2;
                widthResolution = wr;
                heightResolution = hr;
                break;
            }
            case 270: {
                xOrigin = y + this.yOffset;
                yOrigin = this.currentPage.getHeight() - x - this.xOffset;
                width = h2;
                height = w;
                widthResolution = hr;
                heightResolution = wr;
                break;
            }
            default: {
                xOrigin = x + this.xOffset;
                yOrigin = y + this.yOffset;
                width = w;
                height = h2;
                widthResolution = wr;
                heightResolution = hr;
            }
        }
        ImageObject io = this.currentPage.getImageObject();
        io.setImageViewport(xOrigin, yOrigin, width, height, this.rotation, widthResolution, heightResolution);
        return io;
    }

    public void createLine(int x1, int y1, int x2, int y2, int thickness, Color col) {
        this.currentPage.createLine(x1 + this.xOffset, y1 + this.yOffset, x2 + this.xOffset, y2 + this.yOffset, thickness, this.rotation, col);
    }

    public void createShading(int x, int y, int w, int h2, int red, int green, int blue) {
        this.currentPage.createShading(x + this.xOffset, y + this.xOffset, w, h2, red, green, blue);
    }

    public void createIncludePageOverlay(String name) {
        this.currentPageObject.createIncludePageOverlay(name, 0, 0, this.rotation);
        ActiveEnvironmentGroup aeg = this.currentPageObject.getActiveEnvironmentGroup();
        aeg.createOverlay(name);
    }

    public void createInvokeMediumMap(String name) {
        if (this.currentPageGroup == null) {
            this.startPageGroup();
        }
        this.currentPageGroup.createInvokeMediumMap(name);
    }

    public void createIncludePageSegment(String name, int x, int y) {
        int yOrigin;
        int xOrigin;
        switch (this.rotation) {
            case 90: {
                xOrigin = this.currentPage.getWidth() - y - this.yOffset;
                yOrigin = x + this.xOffset;
                break;
            }
            case 180: {
                xOrigin = this.currentPage.getWidth() - x - this.xOffset;
                yOrigin = this.currentPage.getHeight() - y - this.yOffset;
                break;
            }
            case 270: {
                xOrigin = y + this.yOffset;
                yOrigin = this.currentPage.getHeight() - x - this.xOffset;
                break;
            }
            default: {
                xOrigin = x + this.xOffset;
                yOrigin = y + this.yOffset;
            }
        }
        this.currentPage.createIncludePageSegment(name, xOrigin, yOrigin);
    }

    public void createPageTagLogicalElement(TagLogicalElementBean[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i].getKey();
            String value = attributes[i].getValue();
            this.currentPage.createTagLogicalElement(name, value);
        }
    }

    public void createPageGroupTagLogicalElement(TagLogicalElementBean[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i].getKey();
            String value = attributes[i].getValue();
            this.currentPageGroup.createTagLogicalElement(name, value);
        }
    }

    public void createTagLogicalElement(String name, String value) {
        if (this.currentPageGroup != null) {
            this.currentPageGroup.createTagLogicalElement(name, value);
        } else {
            this.currentPage.createTagLogicalElement(name, value);
        }
    }

    public void createNoOperation(String content) {
        this.currentPage.createNoOperation(content);
    }

    public void startPageGroup() {
        String pageGroupName = "PGP" + StringUtils.lpad(String.valueOf(this.pageCount++), '0', 5);
        this.currentPageGroup = new PageGroup(pageGroupName);
    }

    public void endPageGroup() throws IOException {
        this.currentPageGroup.endPageGroup();
        this.document.addPageGroup(this.currentPageGroup);
        this.document.writeDataStream(this.outputStream);
        this.currentPageGroup = null;
    }

    public void setPortraitRotation(int pageRotation) {
        if (pageRotation != 0 && pageRotation != 90 && pageRotation != 180 && pageRotation != 270) {
            throw new IllegalArgumentException("The portrait rotation must be one of the values 0, 90, 180, 270");
        }
        this.portraitRotation = pageRotation;
    }

    public void setLandscapeRotation(int pageRotation) {
        if (pageRotation != 0 && pageRotation != 90 && pageRotation != 180 && pageRotation != 270) {
            throw new IllegalArgumentException("The landscape rotation must be one of the values 0, 90, 180, 270");
        }
        this.landscapeRotation = pageRotation;
    }
}

