/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.ActiveEnvironmentGroup;
import org.apache.fop.render.afp.modca.IMImageObject;
import org.apache.fop.render.afp.modca.ImageCellPosition;
import org.apache.fop.render.afp.modca.ImageInputDescriptor;
import org.apache.fop.render.afp.modca.ImageObject;
import org.apache.fop.render.afp.modca.ImageOutputControl;
import org.apache.fop.render.afp.modca.ImageRasterData;
import org.apache.fop.render.afp.modca.ImageRasterPattern;
import org.apache.fop.render.afp.modca.IncludePageSegment;
import org.apache.fop.render.afp.modca.NoOperation;
import org.apache.fop.render.afp.modca.PresentationTextObject;
import org.apache.fop.render.afp.modca.TagLogicalElement;
import org.apache.fop.render.afp.tools.StringUtils;

public abstract class AbstractPageObject
extends AbstractNamedAFPObject {
    protected ActiveEnvironmentGroup activeEnvironmentGroup = null;
    private PresentationTextObject presentationTextObject = null;
    protected List objects = new ArrayList();
    protected ArrayList tagLogicalElements = new ArrayList();
    protected ArrayList segments = new ArrayList();
    private int width;
    private int height;
    private int rotation = 0;
    private boolean complete = false;

    public AbstractPageObject(String name, int width, int height, int rotation, int widthResolution, int heightResolution) {
        super(name);
        this.width = width;
        this.height = height;
        this.rotation = rotation;
        this.activeEnvironmentGroup = new ActiveEnvironmentGroup(width, height, widthResolution, heightResolution);
        if (rotation != 0) {
            switch (rotation) {
                case 90: {
                    this.activeEnvironmentGroup.setPosition(width, 0, rotation);
                    break;
                }
                case 180: {
                    this.activeEnvironmentGroup.setPosition(width, height, rotation);
                    break;
                }
                case 270: {
                    this.activeEnvironmentGroup.setPosition(0, height, rotation);
                    break;
                }
            }
        }
        this.presentationTextObject = new PresentationTextObject();
        this.objects.add(this.presentationTextObject);
    }

    public void createFont(byte fontReference, AFPFont font, int size) {
        this.activeEnvironmentGroup.createFont(fontReference, font, size, 0);
    }

    public void createLine(int x1, int y1, int x2, int y2, int thickness, int lineRotation, Color col) {
        if (this.presentationTextObject == null) {
            this.presentationTextObject = new PresentationTextObject();
            this.objects.add(this.presentationTextObject);
        }
        this.presentationTextObject.createLineData(x1, y1, x2, y2, thickness, lineRotation, col);
    }

    public void createText(int fontNumber, int x, int y, int textRotation, Color col, int vsci, int ica, byte[] data) {
        if (this.presentationTextObject == null) {
            this.presentationTextObject = new PresentationTextObject();
            this.objects.add(this.presentationTextObject);
        }
        this.presentationTextObject.createTextData(fontNumber, x, y, textRotation, col, vsci, ica, data);
    }

    public void endPage() {
        if (this.presentationTextObject != null) {
            this.presentationTextObject.endControlSequence();
        }
        this.complete = true;
    }

    public void createShading(int x, int y, int w, int h2, int red, int green, int blue) {
        int xCoord = 0;
        int yCoord = 0;
        int areaWidth = 0;
        int areaHeight = 0;
        switch (this.rotation) {
            case 90: {
                xCoord = areaWidth - y - h2;
                yCoord = x;
                areaWidth = h2;
                areaHeight = w;
                break;
            }
            case 180: {
                xCoord = areaWidth - x - w;
                yCoord = areaHeight - y - h2;
                areaWidth = w;
                areaHeight = h2;
                break;
            }
            case 270: {
                xCoord = y;
                yCoord = areaHeight - x - w;
                areaWidth = h2;
                areaHeight = w;
                break;
            }
            default: {
                xCoord = x;
                yCoord = y;
                areaWidth = w;
                areaHeight = h2;
            }
        }
        float shade = (float)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
        int greyscale = Math.round(shade / 255.0f * 16.0f);
        String imageName = "IMG" + StringUtils.lpad(String.valueOf(this.objects.size() + 1), '0', 5);
        IMImageObject io = new IMImageObject(imageName);
        ImageOutputControl ioc = new ImageOutputControl(0, 0);
        ImageInputDescriptor iid = new ImageInputDescriptor();
        ImageCellPosition icp = new ImageCellPosition(xCoord, yCoord);
        icp.setXFillSize(areaWidth);
        icp.setYFillSize(areaHeight);
        icp.setXSize(64);
        icp.setYSize(8);
        ImageRasterData ird = new ImageRasterData(ImageRasterPattern.getRasterData(greyscale));
        io.setImageOutputControl(ioc);
        io.setImageInputDescriptor(iid);
        io.setImageCellPosition(icp);
        io.setImageRasterData(ird);
        this.objects.add(io);
    }

    public ImageObject getImageObject() {
        if (this.presentationTextObject != null) {
            this.presentationTextObject.endControlSequence();
        }
        this.presentationTextObject = null;
        String imageName = "IMG" + StringUtils.lpad(String.valueOf(this.objects.size() + 1), '0', 5);
        ImageObject io = new ImageObject(imageName);
        this.objects.add(io);
        return io;
    }

    public void createTagLogicalElement(String name, String value) {
        TagLogicalElement tle = new TagLogicalElement(name, value);
        this.tagLogicalElements.add(tle);
    }

    public void createNoOperation(String content) {
        NoOperation noOp = new NoOperation(content);
        this.objects.add(noOp);
    }

    public void createIncludePageSegment(String name, int xCoor, int yCoor) {
        IncludePageSegment ips = new IncludePageSegment(name, xCoor, yCoor);
        this.segments.add(ips);
    }

    public ActiveEnvironmentGroup getActiveEnvironmentGroup() {
        return this.activeEnvironmentGroup;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRotation() {
        return this.rotation;
    }
}

