/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.geom.AffineTransform;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.fop.render.java2d.Java2DRendererContextConstants;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;

public class Java2DSVGHandler
implements XMLHandler,
Java2DRendererContextConstants {
    private static Log log = LogFactory.getLog(Java2DSVGHandler.class);

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        Java2DInfo pdfi = Java2DSVGHandler.getJava2DInfo(context);
        if ("http://www.w3.org/2000/svg".equals(ns)) {
            this.renderSVGDocument(context, doc, pdfi);
        }
    }

    public static Java2DInfo getJava2DInfo(RendererContext context) {
        Java2DInfo pdfi = new Java2DInfo();
        pdfi.state = (Java2DGraphicsState)context.getProperty("state");
        pdfi.width = (Integer)context.getProperty("width");
        pdfi.height = (Integer)context.getProperty("height");
        pdfi.currentXPosition = (Integer)context.getProperty("xpos");
        pdfi.currentYPosition = (Integer)context.getProperty("ypos");
        return pdfi;
    }

    protected void renderSVGDocument(RendererContext context, Document doc, Java2DInfo info) {
        GraphicsNode root;
        log.debug("renderSVGDocument(" + context + ", " + doc + ", " + info + ")");
        int x = info.currentXPosition;
        int y = info.currentYPosition;
        float ptom = context.getUserAgent().getSourcePixelUnitToMillimeter();
        SVGUserAgent ua = new SVGUserAgent(ptom, new AffineTransform());
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext(ua);
        try {
            root = builder.build(ctx, doc);
        }
        catch (Exception e) {
            log.error("SVG graphic could not be built: " + e.getMessage(), e);
            return;
        }
        float iw = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
        float ih = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
        float w = info.width;
        float h2 = info.height;
        AffineTransform origTransform = info.state.getGraph().getTransform();
        info.state.getGraph().translate((float)x / 1000.0f, (float)y / 1000.0f);
        AffineTransform at = AffineTransform.getScaleInstance(w / iw, h2 / ih);
        if (!at.isIdentity()) {
            info.state.getGraph().transform(at);
        }
        try {
            root.paint(info.state.getGraph());
        }
        catch (Exception e) {
            log.error("Error while painting SVG", e);
        }
        info.state.getGraph().setTransform(origTransform);
    }

    public boolean supportsRenderer(Renderer renderer) {
        return renderer instanceof Java2DRenderer;
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/svg";
    }

    public static class Java2DInfo {
        public Java2DGraphicsState state;
        public int width;
        public int height;
        public int currentXPosition;
        public int currentYPosition;

        public String toString() {
            return "Java2DInfo {state = " + this.state + ", " + "width = " + this.width + ", " + "height = " + this.height + ", " + "currentXPosition = " + this.currentXPosition + ", " + "currentYPosition = " + this.currentYPosition + "}";
        }
    }
}

