/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.apt;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.maven.doxia.module.apt.AptMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.codehaus.plexus.util.StringUtils;

public class AptSink
extends AbstractTextSink
implements AptMarkup {
    private StringBuffer buffer;
    private StringBuilder tableCaptionBuffer;
    private String author;
    private String title;
    private String date;
    private boolean startFlag;
    private boolean tableCaptionFlag;
    private boolean headerFlag;
    private boolean bufferFlag;
    private boolean itemFlag;
    private boolean verbatimFlag;
    private boolean isBoxed;
    private boolean gridFlag;
    private int cellCount;
    private final PrintWriter writer;
    private int[] cellJustif;
    private String rowLine;
    private String listNestingIndent;
    private final Stack<String> listStyles;

    protected AptSink(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.listStyles = new Stack();
        this.init();
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headerFlag = headFlag;
    }

    protected void resetState() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.resetBuffer();
        this.tableCaptionBuffer = new StringBuilder();
        this.listNestingIndent = "";
        this.author = null;
        this.title = null;
        this.date = null;
        this.startFlag = true;
        this.tableCaptionFlag = false;
        this.headerFlag = false;
        this.bufferFlag = false;
        this.itemFlag = false;
        this.verbatimFlag = false;
        this.isBoxed = false;
        this.gridFlag = false;
        this.cellCount = 0;
        this.cellJustif = null;
        this.rowLine = null;
        this.listStyles.clear();
    }

    protected void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    protected void resetTableCaptionBuffer() {
        this.tableCaptionBuffer = new StringBuilder();
    }

    @Override
    public void head() {
        boolean startFlag = this.startFlag;
        this.init();
        this.headerFlag = true;
        this.startFlag = startFlag;
    }

    @Override
    public void head_() {
        this.headerFlag = false;
        if (!this.startFlag) {
            this.write(EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
        if (this.title != null) {
            this.write(" " + this.title + EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
        if (this.author != null) {
            this.write(" " + this.author + EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
        if (this.date != null) {
            this.write(" " + this.date + EOL);
        }
        this.write(HEADER_START_MARKUP + EOL);
    }

    @Override
    public void title_() {
        if (this.buffer.length() > 0) {
            this.title = this.buffer.toString();
            this.resetBuffer();
        }
    }

    @Override
    public void author_() {
        if (this.buffer.length() > 0) {
            this.author = this.buffer.toString();
            this.resetBuffer();
        }
    }

    @Override
    public void date_() {
        if (this.buffer.length() > 0) {
            this.date = this.buffer.toString();
            this.resetBuffer();
        }
    }

    @Override
    public void section1_() {
        this.write(EOL);
    }

    @Override
    public void section2_() {
        this.write(EOL);
    }

    @Override
    public void section3_() {
        this.write(EOL);
    }

    @Override
    public void section4_() {
        this.write(EOL);
    }

    @Override
    public void section5_() {
        this.write(EOL);
    }

    @Override
    public void sectionTitle1() {
        this.write(EOL);
    }

    @Override
    public void sectionTitle1_() {
        this.write(EOL + EOL);
    }

    @Override
    public void sectionTitle2() {
        this.write(EOL + SECTION_TITLE_START_MARKUP);
    }

    @Override
    public void sectionTitle2_() {
        this.write(EOL + EOL);
    }

    @Override
    public void sectionTitle3() {
        this.write(EOL + StringUtils.repeat(SECTION_TITLE_START_MARKUP, 2));
    }

    @Override
    public void sectionTitle3_() {
        this.write(EOL + EOL);
    }

    @Override
    public void sectionTitle4() {
        this.write(EOL + StringUtils.repeat(SECTION_TITLE_START_MARKUP, 3));
    }

    @Override
    public void sectionTitle4_() {
        this.write(EOL + EOL);
    }

    @Override
    public void sectionTitle5() {
        this.write(EOL + StringUtils.repeat(SECTION_TITLE_START_MARKUP, 4));
    }

    @Override
    public void sectionTitle5_() {
        this.write(EOL + EOL);
    }

    @Override
    public void list() {
        this.listNestingIndent = this.listNestingIndent + " ";
        this.listStyles.push(LIST_START_MARKUP);
        this.write(EOL);
    }

    @Override
    public void list_() {
        if (this.listNestingIndent.length() <= 1) {
            this.write(EOL + this.listNestingIndent + LIST_END_MARKUP + EOL);
        } else {
            this.write(EOL);
        }
        this.listNestingIndent = StringUtils.chomp(this.listNestingIndent, " ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    @Override
    public void listItem() {
        this.numberedListItem();
        this.itemFlag = true;
    }

    @Override
    public void listItem_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    @Override
    public void numberedList(int numbering) {
        String style;
        this.listNestingIndent = this.listNestingIndent + " ";
        this.write(EOL);
        switch (numbering) {
            case 2: {
                style = String.valueOf('A');
                break;
            }
            case 1: {
                style = String.valueOf('a');
                break;
            }
            case 4: {
                style = String.valueOf('I');
                break;
            }
            case 3: {
                style = String.valueOf('i');
                break;
            }
            default: {
                style = String.valueOf('1');
            }
        }
        this.listStyles.push(style);
    }

    @Override
    public void numberedList_() {
        if (this.listNestingIndent.length() <= 1) {
            this.write(EOL + this.listNestingIndent + LIST_END_MARKUP + EOL);
        } else {
            this.write(EOL);
        }
        this.listNestingIndent = StringUtils.chomp(this.listNestingIndent, " ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    @Override
    public void numberedListItem() {
        String style = this.listStyles.peek();
        if (style.equals(String.valueOf('*'))) {
            this.write(EOL + this.listNestingIndent + String.valueOf('*') + String.valueOf(' '));
        } else {
            this.write(EOL + this.listNestingIndent + String.valueOf('[') + String.valueOf('[') + style + String.valueOf(']') + String.valueOf(']') + String.valueOf(' '));
        }
        this.itemFlag = true;
    }

    @Override
    public void numberedListItem_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    @Override
    public void definitionList() {
        this.listNestingIndent = this.listNestingIndent + " ";
        this.listStyles.push("");
        this.write(EOL);
    }

    @Override
    public void definitionList_() {
        if (this.listNestingIndent.length() <= 1) {
            this.write(EOL + this.listNestingIndent + LIST_END_MARKUP + EOL);
        } else {
            this.write(EOL);
        }
        this.listNestingIndent = StringUtils.chomp(this.listNestingIndent, " ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    @Override
    public void definedTerm() {
        this.write(EOL + " [");
    }

    @Override
    public void definedTerm_() {
        this.write("] ");
    }

    @Override
    public void definition() {
        this.itemFlag = true;
    }

    @Override
    public void definition_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    @Override
    public void pageBreak() {
        this.write(EOL + '\f' + EOL);
    }

    @Override
    public void paragraph() {
        if (this.itemFlag) {
            this.write(EOL + EOL + "  " + this.listNestingIndent);
        } else {
            this.write(EOL + " ");
        }
    }

    @Override
    public void paragraph_() {
        this.write(EOL + EOL);
    }

    @Override
    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.isBoxed = boxed;
        this.write(EOL);
        if (boxed) {
            this.write(EOL + BOXED_VERBATIM_START_MARKUP + EOL);
        } else {
            this.write(EOL + NON_BOXED_VERBATIM_START_MARKUP + EOL);
        }
    }

    @Override
    public void verbatim_() {
        if (this.isBoxed) {
            this.write(EOL + BOXED_VERBATIM_END_MARKUP + EOL);
        } else {
            this.write(EOL + NON_BOXED_VERBATIM_END_MARKUP + EOL);
        }
        this.isBoxed = false;
        this.verbatimFlag = false;
    }

    @Override
    public void horizontalRule() {
        this.write(EOL + HORIZONTAL_RULE_MARKUP + EOL);
    }

    @Override
    public void table() {
        this.write(EOL);
    }

    @Override
    public void table_() {
        if (this.rowLine != null) {
            this.write(this.rowLine);
        }
        this.rowLine = null;
        if (this.tableCaptionBuffer.length() > 0) {
            this.text(this.tableCaptionBuffer.toString() + EOL);
        }
        this.resetTableCaptionBuffer();
    }

    @Override
    public void tableRows(int[] justification, boolean grid) {
        this.cellJustif = justification;
        this.gridFlag = grid;
    }

    @Override
    public void tableRows_() {
        this.cellJustif = null;
        this.gridFlag = false;
    }

    @Override
    public void tableRow() {
        this.bufferFlag = true;
        this.cellCount = 0;
    }

    @Override
    public void tableRow_() {
        this.bufferFlag = false;
        this.buildRowLine();
        this.write(this.rowLine);
        if (this.gridFlag) {
            this.write(TABLE_ROW_SEPARATOR_MARKUP);
        }
        this.write(this.buffer.toString());
        this.resetBuffer();
        this.write(EOL);
        this.cellCount = 0;
    }

    private void buildRowLine() {
        StringBuilder rLine = new StringBuilder();
        rLine.append(TABLE_ROW_START_MARKUP);
        for (int i = 0; i < this.cellCount; ++i) {
            if (this.cellJustif != null) {
                switch (this.cellJustif[i]) {
                    case 1: {
                        rLine.append(TABLE_COL_LEFT_ALIGNED_MARKUP);
                        break;
                    }
                    case 2: {
                        rLine.append(TABLE_COL_RIGHT_ALIGNED_MARKUP);
                        break;
                    }
                    default: {
                        rLine.append(TABLE_COL_CENTERED_ALIGNED_MARKUP);
                        break;
                    }
                }
                continue;
            }
            rLine.append(TABLE_COL_CENTERED_ALIGNED_MARKUP);
        }
        rLine.append(EOL);
        this.rowLine = rLine.toString();
    }

    @Override
    public void tableCell() {
        this.tableCell(false);
    }

    @Override
    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableCell(boolean headerRow) {
        if (headerRow) {
            this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        }
    }

    @Override
    public void tableCell_() {
        this.endTableCell();
    }

    @Override
    public void tableHeaderCell_() {
        this.endTableCell();
    }

    private void endTableCell() {
        this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        ++this.cellCount;
    }

    @Override
    public void tableCaption() {
        this.tableCaptionFlag = true;
    }

    @Override
    public void tableCaption_() {
        this.tableCaptionFlag = false;
    }

    @Override
    public void figureCaption_() {
        this.write(EOL);
    }

    @Override
    public void figureGraphics(String name) {
        this.write(EOL + "[" + name + "] ");
    }

    @Override
    public void anchor(String name) {
        this.write(ANCHOR_START_MARKUP);
    }

    @Override
    public void anchor_() {
        this.write(ANCHOR_END_MARKUP);
    }

    @Override
    public void link(String name) {
        if (!this.headerFlag) {
            this.write(LINK_START_1_MARKUP);
            this.text(name.startsWith("#") ? name.substring(1) : name);
            this.write(LINK_START_2_MARKUP);
        }
    }

    @Override
    public void link_() {
        if (!this.headerFlag) {
            this.write(LINK_END_MARKUP);
        }
    }

    public void link(String name, String target) {
        if (!this.headerFlag) {
            this.write(LINK_START_1_MARKUP);
            this.text(target);
            this.write(LINK_START_2_MARKUP);
            this.text(name);
        }
    }

    @Override
    public void italic() {
        if (!this.headerFlag) {
            this.write(ITALIC_START_MARKUP);
        }
    }

    @Override
    public void italic_() {
        if (!this.headerFlag) {
            this.write(ITALIC_END_MARKUP);
        }
    }

    @Override
    public void bold() {
        if (!this.headerFlag) {
            this.write(BOLD_START_MARKUP);
        }
    }

    @Override
    public void bold_() {
        if (!this.headerFlag) {
            this.write(BOLD_END_MARKUP);
        }
    }

    @Override
    public void monospaced() {
        if (!this.headerFlag) {
            this.write(MONOSPACED_START_MARKUP);
        }
    }

    @Override
    public void monospaced_() {
        if (!this.headerFlag) {
            this.write(MONOSPACED_END_MARKUP);
        }
    }

    @Override
    public void lineBreak() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(EOL);
        } else if (this.verbatimFlag) {
            this.write(EOL);
        } else {
            this.write("\\" + EOL);
        }
    }

    @Override
    public void nonBreakingSpace() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(NON_BREAKING_SPACE_MARKUP);
        } else {
            this.write(NON_BREAKING_SPACE_MARKUP);
        }
    }

    @Override
    public void text(String text) {
        if (this.tableCaptionFlag) {
            this.tableCaptionBuffer.append(text);
        } else if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    @Override
    public void rawText(String text) {
        this.write(text);
    }

    @Override
    public void comment(String comment) {
        this.rawText((this.startFlag ? "" : EOL) + '~' + '~' + comment);
    }

    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.getLog().warn("[Apt Sink] Unknown Sink event: '" + name + "', ignoring!");
    }

    protected void write(String text) {
        this.startFlag = false;
        this.writer.write(AptSink.unifyEOLs(text));
    }

    protected void content(String text) {
        this.write(AptSink.escapeAPT(text));
    }

    protected void verbatimContent(String text) {
        this.write(AptSink.escapeAPT(text));
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
        this.init();
    }

    private static String escapeAPT(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '*': 
                case '+': 
                case '-': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

