/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.bean;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class WriteTag
extends TagSupport {
    public static final String SQL_TIMESTAMP_FORMAT_KEY = "org.apache.struts.taglib.bean.format.sql.timestamp";
    public static final String SQL_DATE_FORMAT_KEY = "org.apache.struts.taglib.bean.format.sql.date";
    public static final String SQL_TIME_FORMAT_KEY = "org.apache.struts.taglib.bean.format.sql.time";
    public static final String DATE_FORMAT_KEY = "org.apache.struts.taglib.bean.format.date";
    public static final String INT_FORMAT_KEY = "org.apache.struts.taglib.bean.format.int";
    public static final String FLOAT_FORMAT_KEY = "org.apache.struts.taglib.bean.format.float";
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.bean.LocalStrings");
    protected boolean filter = true;
    protected boolean ignore = false;
    protected String name = null;
    protected String property = null;
    protected String scope = null;
    protected String formatStr = null;
    protected String formatKey = null;
    protected String localeKey = null;
    protected String bundle = null;

    public boolean getFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getFormat() {
        return this.formatStr;
    }

    public void setFormat(String formatStr) {
        this.formatStr = formatStr;
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    public String getLocale() {
        return this.localeKey;
    }

    public void setLocale(String localeKey) {
        this.localeKey = localeKey;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public int doStartTag() throws JspException {
        if (this.ignore && TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope) == null) {
            return 0;
        }
        Object value = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope);
        if (value == null) {
            return 0;
        }
        String output = this.formatValue(value);
        if (this.filter) {
            TagUtils.getInstance().write(this.pageContext, TagUtils.getInstance().filter(output));
        } else {
            TagUtils.getInstance().write(this.pageContext, output);
        }
        return 0;
    }

    protected String retrieveFormatString(String formatKey) throws JspException {
        String result = TagUtils.getInstance().message(this.pageContext, this.bundle, this.localeKey, formatKey);
        if (!(result == null || result.startsWith("???") && result.endsWith("???"))) {
            return result;
        }
        return null;
    }

    protected String formatValue(Object valueToFormat) throws JspException {
        Format format = null;
        Object value = valueToFormat;
        Locale locale = TagUtils.getInstance().getUserLocale(this.pageContext, this.localeKey);
        boolean formatStrFromResources = false;
        String formatString = this.formatStr;
        if (value instanceof String) {
            return (String)value;
        }
        if (formatString == null && this.formatKey != null && (formatString = this.retrieveFormatString(this.formatKey)) != null) {
            formatStrFromResources = true;
        }
        if (value instanceof Number) {
            if (formatString == null) {
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
                    formatString = this.retrieveFormatString(INT_FORMAT_KEY);
                } else if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
                    formatString = this.retrieveFormatString(FLOAT_FORMAT_KEY);
                }
                if (formatString != null) {
                    formatStrFromResources = true;
                }
            }
            if (formatString != null) {
                try {
                    format = NumberFormat.getNumberInstance(locale);
                    if (formatStrFromResources) {
                        ((DecimalFormat)format).applyLocalizedPattern(formatString);
                    }
                    ((DecimalFormat)format).applyPattern(formatString);
                }
                catch (IllegalArgumentException e) {
                    JspException ex = new JspException(messages.getMessage("write.format", (Object)formatString));
                    TagUtils.getInstance().saveException(this.pageContext, (Throwable)ex);
                    throw ex;
                }
            }
        } else if (value instanceof java.util.Date) {
            if (formatString == null) {
                if (value instanceof Timestamp) {
                    formatString = this.retrieveFormatString(SQL_TIMESTAMP_FORMAT_KEY);
                } else if (value instanceof Date) {
                    formatString = this.retrieveFormatString(SQL_DATE_FORMAT_KEY);
                } else if (value instanceof Time) {
                    formatString = this.retrieveFormatString(SQL_TIME_FORMAT_KEY);
                } else if (value instanceof java.util.Date) {
                    formatString = this.retrieveFormatString(DATE_FORMAT_KEY);
                }
            }
            if (formatString != null) {
                format = new SimpleDateFormat(formatString, locale);
            }
        }
        if (format != null) {
            return format.format(value);
        }
        return value.toString();
    }

    public void release() {
        super.release();
        this.filter = true;
        this.ignore = false;
        this.name = null;
        this.property = null;
        this.scope = null;
        this.formatStr = null;
        this.formatKey = null;
        this.localeKey = null;
        this.bundle = null;
    }
}

