/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Hashtable;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class VelocimacroManager {
    private final RuntimeServices rsvc;
    private static String GLOBAL_NAMESPACE = "";
    private boolean registerFromLib = false;
    private final Hashtable namespaceHash = new Hashtable();
    private final Hashtable libraryMap = new Hashtable();
    private boolean namespacesOn = true;
    private boolean inlineLocalMode = false;

    VelocimacroManager(RuntimeServices rsvc) {
        this.rsvc = rsvc;
        this.addNamespace(GLOBAL_NAMESPACE);
    }

    public boolean addVM(String vmName, String macroBody, String[] argArray, String namespace) {
        MacroEntry me = new MacroEntry(vmName, macroBody, argArray, namespace);
        me.setFromLibrary(this.registerFromLib);
        boolean isLib = true;
        if (this.registerFromLib) {
            this.libraryMap.put(namespace, namespace);
        } else {
            isLib = this.libraryMap.containsKey(namespace);
        }
        if (!isLib && this.usingNamespaces(namespace)) {
            Hashtable local = this.getNamespace(namespace, true);
            local.put(vmName, me);
            return true;
        }
        MacroEntry exist = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (exist != null) {
            me.setFromLibrary(exist.getFromLibrary());
        }
        this.getNamespace(GLOBAL_NAMESPACE).put(vmName, me);
        return true;
    }

    public VelocimacroProxy get(String vmName, String namespace) {
        MacroEntry me;
        Hashtable local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return me.createVelocimacro(namespace);
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.createVelocimacro(namespace);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpNamespace(String namespace) {
        VelocimacroManager velocimacroManager = this;
        synchronized (velocimacroManager) {
            if (this.usingNamespaces(namespace)) {
                Hashtable h2 = (Hashtable)this.namespaceHash.remove(namespace);
                if (h2 == null) {
                    return false;
                }
                h2.clear();
                return true;
            }
            return false;
        }
    }

    public void setNamespaceUsage(boolean namespaceOn) {
        this.namespacesOn = namespaceOn;
    }

    public void setRegisterFromLib(boolean registerFromLib) {
        this.registerFromLib = registerFromLib;
    }

    public void setTemplateLocalInlineVM(boolean inlineLocalMode) {
        this.inlineLocalMode = inlineLocalMode;
    }

    private Hashtable getNamespace(String namespace) {
        return this.getNamespace(namespace, false);
    }

    private Hashtable getNamespace(String namespace, boolean addIfNew) {
        Hashtable h2 = (Hashtable)this.namespaceHash.get(namespace);
        if (h2 == null && addIfNew) {
            h2 = this.addNamespace(namespace);
        }
        return h2;
    }

    private Hashtable addNamespace(String namespace) {
        Hashtable h2 = new Hashtable();
        Hashtable oh = this.namespaceHash.put(namespace, h2);
        if (oh != null) {
            this.namespaceHash.put(namespace, oh);
            return null;
        }
        return h2;
    }

    private boolean usingNamespaces(String namespace) {
        if (!this.namespacesOn) {
            return false;
        }
        return this.inlineLocalMode;
    }

    public String getLibraryName(String vmName, String namespace) {
        MacroEntry me;
        Hashtable local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return null;
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.getSourceTemplate();
        }
        return null;
    }

    private class MacroEntry {
        private final String vmName;
        private final String[] argArray;
        private final String macroBody;
        private final String sourceTemplate;
        private SimpleNode nodeTree = null;
        private boolean fromLibrary = false;

        private MacroEntry(String vmName, String macroBody, String[] argArray, String sourceTemplate) {
            this.vmName = vmName;
            this.argArray = argArray;
            this.macroBody = macroBody;
            this.sourceTemplate = sourceTemplate;
        }

        public void setFromLibrary(boolean fromLibrary) {
            this.fromLibrary = fromLibrary;
        }

        public boolean getFromLibrary() {
            return this.fromLibrary;
        }

        public SimpleNode getNodeTree() {
            return this.nodeTree;
        }

        public String getSourceTemplate() {
            return this.sourceTemplate;
        }

        VelocimacroProxy createVelocimacro(String namespace) {
            VelocimacroProxy vp = new VelocimacroProxy();
            vp.setName(this.vmName);
            vp.setArgArray(this.argArray);
            vp.setMacrobody(this.macroBody);
            vp.setNodeTree(this.nodeTree);
            vp.setNamespace(namespace);
            return vp;
        }

        void setup(InternalContextAdapter ica) {
            if (this.nodeTree == null) {
                this.parseTree(ica);
            }
        }

        void parseTree(InternalContextAdapter ica) {
            try {
                BufferedReader br = new BufferedReader(new StringReader(this.macroBody));
                this.nodeTree = VelocimacroManager.this.rsvc.parse(br, "VM:" + this.vmName, true);
                this.nodeTree.init(ica, null);
            }
            catch (Exception e) {
                VelocimacroManager.this.rsvc.getLog().error("VelocimacroManager.parseTree() failed on VM '" + this.vmName + "'", e);
            }
        }
    }
}

