/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.IOException;
import java.net.Socket;
import org.openmuc.jsml.transport.ServerThread;
import org.openmuc.jsml.transport.TConnection;

public class ConnectionHandler
extends Thread {
    private final Socket socket;
    private final ServerThread serverThread;

    ConnectionHandler(Socket socket, ServerThread serverThread) {
        this.socket = socket;
        this.serverThread = serverThread;
    }

    @Override
    public void run() {
        try {
            TConnection tConnection;
            try {
                tConnection = new TConnection(this.socket, this.serverThread.messageTimeout, this.serverThread.messageFragmentTimeout);
            }
            catch (IOException e) {
                System.err.println("Exception occurred when someone tried to connect.");
                this.serverThread.removeHandler(this);
                return;
            }
            if (this.serverThread.isAlive()) {
                this.serverThread.connectionIndication(tConnection);
            }
            if (tConnection != null) {
                tConnection.close();
            }
        }
        finally {
            this.serverThread.removeHandler(this);
        }
    }
}

