/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes.embedded;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.DecodingException;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLValidationException;
import com.hastobe.transparenzsoftware.verification.xml.OffsetDateTimeAdapter;
import java.time.OffsetDateTime;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Measurement")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Measurement {
    @XmlJavaTypeAdapter(value=OffsetDateTimeAdapter.class)
    @XmlElement(name="TimestampCustomerIdent")
    private OffsetDateTime timestampCustomerIdent;
    @XmlJavaTypeAdapter(value=OffsetDateTimeAdapter.class)
    @XmlElement(name="Timestamp")
    private OffsetDateTime timestamp;
    @XmlElement(name="Signature")
    private String signature;
    @XmlElement(name="EventCounter")
    private Long eventCounter;
    @XmlElement(name="MeterStatus")
    private Integer meterStatus;
    @XmlElement(name="Value")
    private Long value;
    @XmlElement(name="Scaler")
    private int scaler;
    @XmlElement(name="Pagination")
    private int pagination;
    @XmlElement(name="SecondIndex")
    private int secondIndex;

    public OffsetDateTime getTimestampCustomerIdent() {
        return this.timestampCustomerIdent;
    }

    public void setTimestampCustomerIdent(OffsetDateTime timestampCustomerIdent) {
        this.timestampCustomerIdent = timestampCustomerIdent;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public String getSignature() {
        return this.signature != null ? Utils.clearString(this.signature) : null;
    }

    public byte[] getSignatureAsBytes() throws SMLValidationException {
        try {
            if (this.getSignature() == null) {
                throw new SMLValidationException("Invalid signature provided", "error.sml.mennekes.invalid.signature");
            }
            return EncodingType.hexDecode(this.getSignature());
        }
        catch (DecodingException e) {
            throw new SMLValidationException("Invalid signature provided", "error.sml.mennekes.invalid.signature");
        }
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Long getEventCounter() {
        return this.eventCounter;
    }

    public void setEventCounter(Long eventCounter) {
        this.eventCounter = eventCounter;
    }

    public Integer getMeterStatus() {
        return this.meterStatus;
    }

    public void setMeterStatus(Integer meterStatus) {
        this.meterStatus = meterStatus;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public int getScaler() {
        return this.scaler;
    }

    public void setScaler(int scaler) {
        this.scaler = scaler;
    }

    public int getPagination() {
        return this.pagination;
    }

    public void setPagination(int pagination) {
        this.pagination = pagination;
    }

    public int getSecondIndex() {
        return this.secondIndex;
    }

    public void setSecondIndex(int secondIndex) {
        this.secondIndex = secondIndex;
    }
}

