/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.gui.views.helper.DetailsList;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.FormatComparisonException;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLSignature;
import com.hastobe.transparenzsoftware.verification.xml.LocalDateTimeAdapter;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.VerifiedData;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="verifiedData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SMLVerifiedData
extends VerifiedData {
    private String secondsIndex;
    private VerificationType verificationType;
    private EncodingType encodingType;
    private String publicKey;
    private String serverId;
    private String status;
    private String obisId;
    private String unit;
    private String scaler;
    private double meter;
    private String logbookHigh;
    private String logbookLow;
    private String signature;
    private String customerId;
    private int pagination;
    private OffsetDateTime timestampCustomerId;
    private List<Meter> meters;

    public SMLVerifiedData() {
    }

    public SMLVerifiedData(SMLSignature smlSignature, VerificationType verificationType, EncodingType encodingType, String publicKey) {
        this.verificationType = verificationType;
        this.encodingType = encodingType;
        this.publicKey = publicKey;
        if (smlSignature != null) {
            this.serverId = Utils.toFormattedHex(smlSignature.getServerId());
            this.meters = new ArrayList<Meter>();
            this.meter = smlSignature.getMeterPositionAsLong();
            this.meter = this.meter != 0.0 ? this.meter * Math.pow(10.0, smlSignature.getScaler()) / 1000.0 : 0.0;
            this.meters.add(new Meter(this.meter, smlSignature.getTimestampAsDate(), smlSignature.getScaler()));
            this.status = Utils.toFormattedHex(smlSignature.getStatus());
            this.secondsIndex = Utils.toFormattedHex(smlSignature.getSecondsIndex());
            this.pagination = new BigInteger(Utils.reverseByteOrder(smlSignature.getPagination())).intValue();
            this.obisId = Utils.toFormattedHex(smlSignature.getObisNr());
            this.unit = Utils.toFormattedHex(smlSignature.getUnit());
            this.scaler = Utils.toFormattedHex(smlSignature.getScaler());
            this.logbookHigh = Integer.toString(smlSignature.getBytesLog()[0]);
            this.logbookLow = Integer.toString(smlSignature.getBytesLog()[1]);
            this.signature = Utils.toFormattedHex(smlSignature.getProvidedSignature());
            this.customerId = Utils.toFormattedHex(Utils.trimPaddingAtEnd(smlSignature.getContractId()));
            this.timestampCustomerId = smlSignature.getTimestampContractIdAsDate();
        }
    }

    @Override
    public List<Meter> getMeters() {
        return this.meters;
    }

    @Override
    public String getFormat() {
        return this.verificationType.name();
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getEncoding() {
        return this.encodingType.getCode();
    }

    @Override
    public DetailsList getAdditionalData() {
        DetailsList additionalData = new DetailsList();
        additionalData.put(Translator.get("app.verify.sml.customerId"), this.getCustomerId());
        additionalData.put(Translator.get("app.verify.sml.secondsIndex"), this.getSecondsIndex());
        additionalData.put(Translator.get("app.verify.sml.logbook"), this.getLogbookHigh() + " " + this.getLogbookLow());
        additionalData.put(Translator.get("app.verify.sml.unit"), this.getUnit());
        additionalData.put(Translator.get("app.verify.sml.obisId"), this.getObisId());
        additionalData.put(Translator.get("app.verify.sml.scaler"), this.getScaler());
        additionalData.put(Translator.get("app.verify.sml.serverId"), this.getServerId());
        additionalData.put(Translator.get("app.verify.sml.signature"), this.getSignature());
        additionalData.put(Translator.get("app.verify.sml.status"), this.getStatus());
        additionalData.put(Translator.get("app.verify.sml.timestampCustomer"), LocalDateTimeAdapter.formattedDateTime(this.getTimestampCustomerId().toLocalDateTime()));
        additionalData.put(Translator.get("app.verify.sml.pagination"), this.getPagination());
        return additionalData;
    }

    @Override
    public boolean lawConform(VerifiedData stopValue) throws RegulationLawException, ValidationException {
        if (!(stopValue instanceof SMLVerifiedData)) {
            throw new FormatComparisonException();
        }
        SMLVerifiedData stopData = (SMLVerifiedData)stopValue;
        if (this.getLogbookHigh() == null || stopData.getLogbookHigh() == null) {
            throw new RegulationLawException("Logbook differs between transactions", "app.verify.law.conform.logbook.differs");
        }
        if (this.getLogbookLow() == null || stopData.getLogbookLow() == null) {
            throw new RegulationLawException("Logbook differs between transactions", "app.verify.law.conform.logbook.differs");
        }
        if (!this.getLogbookHigh().equals(stopData.getLogbookHigh()) || !this.getLogbookLow().equals(stopData.getLogbookLow())) {
            throw new RegulationLawException("Logbook differs between transactions", "app.verify.law.conform.logbook.differs");
        }
        if (this.getCustomerId() == null || !this.getCustomerId().equals(stopData.getCustomerId())) {
            throw new RegulationLawException("Customer ids differs between two values", "app.verify.law.conform.customer.id.differs");
        }
        if (this.getPagination() >= stopData.getPagination()) {
            throw new RegulationLawException("Pagination is of start is higher or equal than the pagination of stop", "app.verify.law.conform.pagination.wrong");
        }
        if (this.getMeter() > stopData.getMeter()) {
            throw new RegulationLawException("Meter value of start is higher than meter value of stop", "app.verify.law.conform.meter.wrong");
        }
        return true;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getObisId() {
        return this.obisId;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getScaler() {
        return this.scaler;
    }

    public double getMeter() {
        return this.meter;
    }

    public String getLogbookHigh() {
        return this.logbookHigh;
    }

    public String getLogbookLow() {
        return this.logbookLow;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public OffsetDateTime getTimestampCustomerId() {
        return this.timestampCustomerId;
    }

    public String getSecondsIndex() {
        return this.secondsIndex;
    }

    public int getPagination() {
        return this.pagination;
    }
}

