/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.xml;

import com.hastobe.transparenzsoftware.Utils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class LocalDateTimeAdapter
extends XmlAdapter<String, LocalDateTime> {
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");

    @Override
    public LocalDateTime unmarshal(String s2) throws Exception {
        return LocalDateTime.parse(Utils.clearString(s2), FORMAT);
    }

    @Override
    public String marshal(LocalDateTime localDateTime) throws Exception {
        return LocalDateTimeAdapter.formattedDateTime(localDateTime);
    }

    public static String formattedDateTime(LocalDateTime localDateTime) {
        return LocalDateTimeAdapter.formattedDateTime(localDateTime, FORMAT);
    }

    public static String formattedDateTime(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return localDateTime != null ? localDateTime.format(dateTimeFormatter) : "";
    }
}

