/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class LPR {
    public static final int UNKNOWN = 0;
    private String host;
    private int port = 515;
    private String user = System.getProperty("user.name");
    private Vector jobs = new Vector();
    private String hostname = null;
    private String jobname = "";
    private String cfAlen;
    private String cfA;
    private int copies = 1;
    private int timeout = 60000;
    private boolean cfA_formatted = false;
    private boolean cfA_postscript = false;
    private boolean cfA_banner = false;
    private boolean cfA_pr = false;

    public LPR() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            System.out.println("can't resolve hostname");
            this.hostname = null;
        }
    }

    public LPR(String string, String string2) {
        this();
        this.setHost(string);
        this.setUser(string2);
    }

    public LPR(String string, int n, String string2) {
        this();
        this.setHost(string);
        this.setUser(string2);
        this.setPort(n);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getCfA_postscript() {
        return this.cfA_postscript;
    }

    public void setCfA_postscript(boolean bl) {
        this.cfA_postscript = bl;
        if (bl) {
            this.cfA_formatted = false;
        }
    }

    public String getCfA_jobname() {
        return this.jobname;
    }

    public void setCfA_jobname(String string) {
        this.jobname = string;
        this.cfA_banner = true;
    }

    public boolean getCfA_pr() {
        return this.cfA_pr;
    }

    public void setCfA_pr(boolean bl) {
        this.cfA_pr = bl;
    }

    public boolean getCfA_banner() {
        return this.cfA_banner;
    }

    public void setCfA_banner(boolean bl) {
        this.cfA_banner = bl;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setCopies(int n) {
        this.copies = n;
    }

    public int getCopies() {
        return this.copies;
    }

    public boolean printWaitingJobs(String string) {
        Socket socket = this.connect();
        if (socket != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.write(1);
                dataOutputStream.writeBytes(string + "\n");
                if (bufferedReader.read() != 0) {
                    System.err.println("Error while start print jobs on queue " + string);
                    return false;
                }
                this.close(socket, bufferedReader, dataOutputStream);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public boolean removeJob(String string, String string2, String string3) {
        Socket socket = this.connect();
        if (socket != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.write(5);
                dataOutputStream.writeBytes(string + " " + string2 + " " + string3 + "\n");
                if (bufferedReader.read() != 0) {
                    System.err.println("Error while remove print job " + string3 + " on queue " + string);
                    return false;
                }
                this.close(socket, bufferedReader, dataOutputStream);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public String getQueueState(String string, boolean bl) {
        Socket socket = this.connect();
        if (socket != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                if (bl) {
                    dataOutputStream.write(3);
                } else {
                    dataOutputStream.write(4);
                }
                dataOutputStream.writeBytes(string + " \n");
                LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);
                String string2 = bufferedReader.readLine();
                this.close(socket, bufferedReader, dataOutputStream);
                return string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public String print(String string, byte[] byArray, String string2) {
        PrintJob printJob = new PrintJob(string, byArray, string2);
        printJob.start();
        return printJob.getJobId();
    }

    public String print(String string, String string2, String string3) {
        PrintJob printJob = new PrintJob(string, string2.toCharArray(), string3);
        printJob.start();
        return printJob.getJobId();
    }

    public String print(String string, char[] cArray, String string2) {
        PrintJob printJob = new PrintJob(string, cArray, string2);
        printJob.start();
        return printJob.getJobId();
    }

    public String print(String string, File file, String string2) {
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[(int)file.length()];
                int n = (int)file.length();
                for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
                }
                fileInputStream.close();
                PrintJob printJob = new PrintJob(string, byArray, string2);
                printJob.start();
                this.waitFor(printJob.getJobId());
                return printJob.getJobId();
            }
            catch (Exception exception) {
                System.out.println("error while printig file " + file.getName() + "\n" + exception.getMessage());
            }
        } else {
            System.out.println("file " + file.getName() + " not found");
        }
        return null;
    }

    public void waitFor(String string) {
        try {
            while (this.jobs.contains(string)) {
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean print(String string, String string2, byte[] byArray, char[] cArray, int n, String string3) {
        Socket socket = this.connect();
        if (socket != null) {
            boolean bl = true;
            this.makecfA(string2, string3);
            String string4 = String.valueOf(n == 1 ? byArray.length : cArray.length);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                System.out.println("jobid: " + string3 + " queue: " + string);
                dataOutputStream.write(2);
                dataOutputStream.writeBytes(string + "\n");
                dataOutputStream.flush();
                if (bufferedReader.read() != 0) {
                    bl = false;
                    System.out.println("Error while start printing on queue " + string);
                }
                dataOutputStream.write(2);
                dataOutputStream.writeBytes(this.cfAlen);
                dataOutputStream.writeBytes(" ");
                dataOutputStream.writeBytes("cfA" + string3 + this.user + "\n");
                dataOutputStream.flush();
                if (bufferedReader.read() != 0) {
                    bl = false;
                    System.out.println("Error while start sending control file");
                }
                dataOutputStream.writeBytes(this.cfA);
                dataOutputStream.writeByte(0);
                dataOutputStream.flush();
                if (bufferedReader.read() != 0) {
                    bl = false;
                    System.out.println("Error while sending control file");
                }
                dataOutputStream.write(3);
                dataOutputStream.writeBytes(string4);
                dataOutputStream.writeBytes(" ");
                dataOutputStream.writeBytes("dfA" + string3 + this.user + "\n");
                dataOutputStream.flush();
                if (bufferedReader.read() != 0) {
                    bl = false;
                    System.err.println("Error while start sending data file");
                }
                if (n == 1) {
                    dataOutputStream.write(byArray);
                } else {
                    dataOutputStream.writeBytes(new String(cArray));
                }
                dataOutputStream.writeByte(0);
                dataOutputStream.flush();
                if (bufferedReader.read() != 0) {
                    bl = false;
                    System.out.println("Error while sending data file");
                }
                dataOutputStream.flush();
                this.close(socket, bufferedReader, dataOutputStream);
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
            }
            return bl;
        }
        return false;
    }

    private Socket connect() {
        try {
            System.out.println("Connect with " + this.host);
            Socket socket = new Socket(InetAddress.getByName(this.host), this.port);
            socket.setSoTimeout(this.timeout);
            return socket;
        }
        catch (Exception exception) {
            System.out.println("Error while connecting to " + this.host + ":" + this.port);
            System.out.println(exception.getMessage());
            return null;
        }
    }

    private void close(Socket socket, BufferedReader bufferedReader, DataOutputStream dataOutputStream) {
        try {
            bufferedReader.close();
            dataOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Errror while closing printerport");
            System.out.println(exception.getMessage());
        }
    }

    private void makecfA(String string, String string2) {
        this.cfA = "";
        if (this.hostname != null) {
            this.cfA = this.cfA + "H" + this.hostname + "\n";
        }
        this.cfA = this.cfA + "P" + this.user + "\n";
        this.cfA = this.cfA + "J" + string + "\n";
        this.cfA = this.cfA + "L" + this.user + "\n";
        if (this.cfA_formatted) {
            this.cfA = this.cfA + "f" + string + "\n";
        }
        if (this.cfA_postscript) {
            this.cfA = this.cfA + "o" + string + "\n";
        }
        if (this.cfA_banner) {
            this.cfA = this.cfA + "L" + this.jobname + "\n";
        }
        this.cfA = this.cfA + "UdfA" + string2 + this.hostname + "\n";
        for (int i = 0; i < this.copies; ++i) {
            this.cfA = this.cfA + "ldfA" + string2 + this.user + "\n";
        }
        this.cfA = this.cfA + "N" + string + "\n";
        this.cfAlen = String.valueOf(this.cfA.length());
        System.out.println(this.cfA);
    }

    private String getNewJobId() {
        return this.fillLeft(String.valueOf((int)Math.floor(Math.random() * 999.0)), 3, "0");
    }

    private String fillLeft(String string, int n, String string2) {
        while (string.length() < n) {
            string = string2 + string;
        }
        return string;
    }

    private class PrintJob
    extends Thread {
        String queue;
        String document;
        String id;
        int mode;
        private byte[] dfA1 = null;
        private char[] dfA2 = null;

        public PrintJob(String string, byte[] byArray, String string2) {
            this.queue = string;
            this.dfA1 = byArray;
            this.document = string2;
            this.mode = 1;
            this.id = LPR.this.getNewJobId();
            LPR.this.jobs.addElement(this.id);
            System.out.println("Printjob (byte) " + this.id + " queue=" + string + " document=" + string2);
        }

        public PrintJob(String string, char[] cArray, String string2) {
            this.queue = string;
            this.dfA2 = cArray;
            this.document = string2;
            this.mode = 2;
            this.id = LPR.this.getNewJobId();
            LPR.this.jobs.addElement(this.id);
            System.out.println("Printjob (char) " + this.id + " queue=" + string + " document=" + string2);
        }

        public void run() {
            boolean bl = false;
            int n = 0;
            System.out.println("Printjob (char) " + this.id + " queue=" + this.queue + " document=" + this.document);
            while (!bl) {
                try {
                    ++n;
                    bl = LPR.this.print(this.queue, this.document, this.dfA1, this.dfA2, this.mode, this.id);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
                if (!bl && n > 5) break;
                if (bl) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            LPR.this.jobs.removeElement(this.id);
            if (bl) {
                System.out.println("Job " + this.id + " allready printed and removed from queue (" + n + " trys)");
            } else {
                System.out.println("Job " + this.id + " not printed and removed from queue (" + n + " trys)");
            }
        }

        public String getJobId() {
            return this.id;
        }
    }
}

