/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.Property;

public final class PropertyCache {
    private static final int SEGMENT_MASK = 31;
    private CacheSegment[] segments = new CacheSegment[32];
    private CacheEntry[] table = new CacheEntry[8];
    boolean[] votesForRehash = new boolean[32];

    private static int hash(Object x) {
        return PropertyCache.hash(x.hashCode());
    }

    private static int hash(int hashCode) {
        int h2 = hashCode;
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    private static boolean eq(Object p, Object q) {
        return p == q || p != null && p.equals(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanSegment(int segmentIndex) {
        CacheEntry entry;
        CacheSegment segment = this.segments[segmentIndex];
        int oldCount = segment.count;
        while ((entry = (CacheEntry)segment.staleEntries.poll()) != null) {
            int bucketIndex = PropertyCache.hash(entry.hash) & this.table.length - 1;
            CacheEntry prev = null;
            CacheEntry e = this.table[bucketIndex];
            while (e != null && e.nextEntry != null && e.hash != entry.hash) {
                prev = e;
                e = e.nextEntry;
            }
            if (e == null) continue;
            if (prev == null) {
                this.table[bucketIndex] = e.nextEntry;
            } else {
                prev.nextEntry = e.nextEntry;
            }
            segment.count--;
        }
        boolean[] blArray = this.votesForRehash;
        synchronized (this.votesForRehash) {
            if (oldCount > segment.count) {
                if (this.votesForRehash[segmentIndex]) {
                    this.votesForRehash[segmentIndex] = false;
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            if (!this.votesForRehash[segmentIndex]) {
                this.votesForRehash[segmentIndex] = true;
                int voteCount = 0;
                int i = 32;
                while (--i >= 0) {
                    if (!this.votesForRehash[i]) continue;
                    ++voteCount;
                }
                if (voteCount > 7) {
                    this.rehash(31);
                    i = 32;
                    while (--i >= 0) {
                        this.votesForRehash[i] = false;
                    }
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void put(Object o) {
        CacheSegment segment;
        int hash = PropertyCache.hash(o);
        CacheSegment cacheSegment = segment = this.segments[hash & 0x1F];
        synchronized (cacheSegment) {
            int index = hash & this.table.length - 1;
            CacheEntry entry = this.table[index];
            if (entry == null) {
                this.table[index] = entry = new CacheEntry(o, null, segment.staleEntries);
                segment.count++;
            } else {
                CacheEntry newEntry;
                Object p = entry.get();
                if (PropertyCache.eq(p, o)) {
                    return;
                }
                this.table[index] = newEntry = new CacheEntry(o, entry, segment.staleEntries);
                segment.count++;
            }
            if (segment.count > 2 * this.table.length) {
                this.cleanSegment(hash & 0x1F);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object get(Object o) {
        CacheSegment segment;
        Object q;
        CacheEntry entry;
        int hash = PropertyCache.hash(o);
        int index = hash & this.table.length - 1;
        CacheEntry e = entry = this.table[index];
        while (e != null) {
            if (e.hash == o.hashCode() && (q = e.get()) != null && PropertyCache.eq(q, o)) {
                return q;
            }
            e = e.nextEntry;
        }
        CacheSegment cacheSegment = segment = this.segments[hash & 0x1F];
        synchronized (cacheSegment) {
            CacheEntry e2 = entry = this.table[index];
            while (e2 != null) {
                if (e2.hash == o.hashCode() && (q = e2.get()) != null && PropertyCache.eq(q, o)) {
                    return q;
                }
                e2 = e2.nextEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rehash(int index) {
        CacheSegment seg;
        CacheSegment cacheSegment = seg = this.segments[index];
        synchronized (cacheSegment) {
            if (index > 0) {
                this.rehash(index - 1);
            } else {
                int newLength = this.table.length << 1;
                if (newLength > 0) {
                    int i = this.segments.length;
                    while (--i >= 0) {
                        this.segments[i].count = 0;
                    }
                    CacheEntry[] newTable = new CacheEntry[newLength];
                    --newLength;
                    int i2 = this.table.length;
                    while (--i2 >= 0) {
                        CacheEntry c = this.table[i2];
                        while (c != null) {
                            Object o = c.get();
                            if (o != null) {
                                int hash = c.hash;
                                int idx = hash & newLength;
                                newTable[idx] = new CacheEntry(o, newTable[idx], this.segments[hash & 0x1F].staleEntries);
                                this.segments[hash & 0x1F].count++;
                            }
                            c = c.nextEntry;
                        }
                    }
                    this.table = newTable;
                }
            }
        }
    }

    public PropertyCache() {
        int i = 32;
        while (--i >= 0) {
            this.segments[i] = new CacheSegment();
        }
    }

    private final Object fetch(Object obj) {
        if (obj == null) {
            return null;
        }
        Object cacheEntry = this.get(obj);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        this.put(obj);
        return obj;
    }

    public final Property fetch(Property prop) {
        return (Property)this.fetch((Object)prop);
    }

    public final CommonHyphenation fetch(CommonHyphenation chy) {
        return (CommonHyphenation)this.fetch((Object)chy);
    }

    public final CommonFont.CachedCommonFont fetch(CommonFont.CachedCommonFont ccf) {
        return (CommonFont.CachedCommonFont)this.fetch((Object)ccf);
    }

    public final CommonFont fetch(CommonFont cf) {
        return (CommonFont)this.fetch((Object)cf);
    }

    private final class CacheSegment {
        private int count = 0;
        private ReferenceQueue staleEntries = new ReferenceQueue();

        private CacheSegment() {
        }
    }

    private final class CacheEntry
    extends WeakReference {
        volatile CacheEntry nextEntry;
        final int hash;

        public CacheEntry(Object p, CacheEntry nextEntry, ReferenceQueue refQueue) {
            super(p, refQueue);
            this.nextEntry = nextEntry;
            this.hash = p.hashCode();
        }
    }
}

