/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.ImageRawJPEGAdapter;
import org.apache.fop.render.pdf.PDFImageHandler;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;

public class PDFImageHandlerRawJPEG
implements PDFImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_JPEG};

    public PDFXObject generateImage(RendererContext context, Image image, Point origin, Rectangle pos) throws IOException {
        PDFRenderer renderer = (PDFRenderer)context.getRenderer();
        ImageRawJPEG jpeg = (ImageRawJPEG)image;
        PDFDocument pdfDoc = (PDFDocument)context.getProperty("pdfDoc");
        PDFResourceContext resContext = (PDFResourceContext)context.getProperty("pdfContext");
        ImageRawJPEGAdapter pdfimage = new ImageRawJPEGAdapter(jpeg, image.getInfo().getOriginalURI());
        PDFImageXObject xobj = pdfDoc.addImage(resContext, pdfimage);
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h2 = (float)pos.getHeight() / 1000.0f;
        renderer.placeImage(x, y, w, h2, xobj);
        return xobj;
    }

    public int getPriority() {
        return 100;
    }

    public Class getSupportedImageClass() {
        return ImageRawJPEG.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }
}

