/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pdf.PDFImageHandler;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.util.Service;

public class PDFImageHandlerRegistry {
    private static Log log = LogFactory.getLog(PDFImageHandlerRegistry.class);
    private static final Comparator HANDLER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            PDFImageHandler h1 = (PDFImageHandler)o1;
            PDFImageHandler h2 = (PDFImageHandler)o2;
            return h1.getPriority() - h2.getPriority();
        }
    };
    private Map handlers = new HashMap();
    private List handlerList = new LinkedList();
    private ImageFlavor[] supportedFlavors = new ImageFlavor[0];
    private int handlerRegistrations;
    private int lastSync;

    public PDFImageHandlerRegistry() {
        this.discoverHandlers();
    }

    public void addHandler(String classname) {
        try {
            PDFImageHandler handlerInstance = (PDFImageHandler)Class.forName(classname).newInstance();
            this.addHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + PDFImageHandler.class.getName());
        }
    }

    public synchronized void addHandler(PDFImageHandler handler) {
        Class imageClass = handler.getSupportedImageClass();
        this.handlers.put(imageClass, handler);
        ListIterator<PDFImageHandler> iter = this.handlerList.listIterator();
        while (iter.hasNext()) {
            PDFImageHandler h2 = (PDFImageHandler)iter.next();
            if (HANDLER_COMPARATOR.compare(handler, h2) >= 0) continue;
            iter.previous();
            break;
        }
        iter.add(handler);
        ++this.handlerRegistrations;
    }

    public PDFImageHandler getHandler(Image img) {
        return this.getHandler(img.getClass());
    }

    protected synchronized PDFImageHandler getHandler(Class imageClass) {
        PDFImageHandler handler = null;
        for (Class cl = imageClass; cl != null && (handler = (PDFImageHandler)this.handlers.get(cl)) == null; cl = cl.getSuperclass()) {
        }
        return handler;
    }

    public synchronized ImageFlavor[] getSupportedFlavors() {
        if (this.lastSync != this.handlerRegistrations) {
            ArrayList<ImageFlavor> flavors = new ArrayList<ImageFlavor>();
            Iterator iter = this.handlerList.iterator();
            while (iter.hasNext()) {
                ImageFlavor[] f = ((PDFImageHandler)iter.next()).getSupportedImageFlavors();
                for (int i = 0; i < f.length; ++i) {
                    flavors.add(f[i]);
                }
            }
            this.supportedFlavors = flavors.toArray(new ImageFlavor[flavors.size()]);
            this.lastSync = this.handlerRegistrations;
        }
        return this.supportedFlavors;
    }

    private void discoverHandlers() {
        Iterator providers = Service.providers(PDFImageHandler.class);
        if (providers != null) {
            while (providers.hasNext()) {
                PDFImageHandler handler = (PDFImageHandler)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding PDFImageHandler: " + handler.getClass().getName());
                    }
                    this.addHandler(handler);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding PDFImageHandler", e);
                }
            }
        }
    }
}

