/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.jackrabbit.commons.xml.SerializingContentHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionDiscovery;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebdavResponseImpl
implements WebdavResponse {
    private static Logger log = LoggerFactory.getLogger(WebdavResponseImpl.class);
    private HttpServletResponse httpResponse;

    public WebdavResponseImpl(HttpServletResponse httpResponse) {
        this(httpResponse, false);
    }

    public WebdavResponseImpl(HttpServletResponse httpResponse, boolean noCache) {
        this.httpResponse = httpResponse;
        if (noCache) {
            this.addHeader("Pragma", "No-cache");
            this.addHeader("Cache-Control", "no-cache");
        }
    }

    public void sendError(DavException exception) throws IOException {
        if (!exception.hasErrorCondition()) {
            this.httpResponse.sendError(exception.getErrorCode(), exception.getStatusPhrase());
        } else {
            this.sendXmlResponse(exception, exception.getErrorCode());
        }
    }

    public void sendMultiStatus(MultiStatus multistatus) throws IOException {
        this.sendXmlResponse(multistatus, 207);
    }

    public void sendLockResponse(ActiveLock lock) throws IOException {
        CodedUrlHeader ltHeader = new CodedUrlHeader("Lock-Token", lock.getToken());
        this.httpResponse.setHeader(ltHeader.getHeaderName(), ltHeader.getHeaderValue());
        DavPropertySet propSet = new DavPropertySet();
        propSet.add(new LockDiscovery(lock));
        this.sendXmlResponse(propSet, 200);
    }

    public void sendRefreshLockResponse(ActiveLock[] locks) throws IOException {
        DavPropertySet propSet = new DavPropertySet();
        propSet.add(new LockDiscovery(locks));
        this.sendXmlResponse(propSet, 200);
    }

    public void sendXmlResponse(XmlSerializable serializable, int status) throws IOException {
        this.httpResponse.setStatus(status);
        if (serializable != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Document doc = DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument();
                doc.appendChild(serializable.toXml(doc));
                DefaultHandler handler = SerializingContentHandler.getSerializer(out);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(doc), new SAXResult(handler));
                this.httpResponse.setContentType("text/xml; charset=UTF-8");
                this.httpResponse.setContentLength(out.size());
                out.writeTo((OutputStream)this.httpResponse.getOutputStream());
            }
            catch (ParserConfigurationException e) {
                log.error(e.getMessage());
                throw new IOException(e.getMessage());
            }
            catch (TransformerException e) {
                log.error(e.getMessage());
                throw new IOException(e.getMessage());
            }
            catch (SAXException e) {
                log.error(e.getMessage());
                throw new IOException(e.getMessage());
            }
        }
    }

    public void sendSubscriptionResponse(Subscription subscription) throws IOException {
        String id = subscription.getSubscriptionId();
        if (id != null) {
            CodedUrlHeader h2 = new CodedUrlHeader("SubscriptionId", id);
            this.httpResponse.setHeader(h2.getHeaderName(), h2.getHeaderValue());
        }
        DavPropertySet propSet = new DavPropertySet();
        propSet.add(new SubscriptionDiscovery(subscription));
        this.sendXmlResponse(propSet, 200);
    }

    public void sendPollResponse(EventDiscovery eventDiscovery) throws IOException {
        this.sendXmlResponse(eventDiscovery, 200);
    }

    public void addCookie(Cookie cookie) {
        this.httpResponse.addCookie(cookie);
    }

    public boolean containsHeader(String s2) {
        return this.httpResponse.containsHeader(s2);
    }

    public String encodeURL(String s2) {
        return this.httpResponse.encodeRedirectURL(s2);
    }

    public String encodeRedirectURL(String s2) {
        return this.httpResponse.encodeRedirectURL(s2);
    }

    public String encodeUrl(String s2) {
        return this.httpResponse.encodeUrl(s2);
    }

    public String encodeRedirectUrl(String s2) {
        return this.httpResponse.encodeRedirectURL(s2);
    }

    public void sendError(int i, String s2) throws IOException {
        this.httpResponse.sendError(i, s2);
    }

    public void sendError(int i) throws IOException {
        this.httpResponse.sendError(i);
    }

    public void sendRedirect(String s2) throws IOException {
        this.httpResponse.sendRedirect(s2);
    }

    public void setDateHeader(String s2, long l) {
        this.httpResponse.setDateHeader(s2, l);
    }

    public void addDateHeader(String s2, long l) {
        this.httpResponse.addDateHeader(s2, l);
    }

    public void setHeader(String s2, String s1) {
        this.httpResponse.setHeader(s2, s1);
    }

    public void addHeader(String s2, String s1) {
        this.httpResponse.addHeader(s2, s1);
    }

    public void setIntHeader(String s2, int i) {
        this.httpResponse.setIntHeader(s2, i);
    }

    public void addIntHeader(String s2, int i) {
        this.httpResponse.addIntHeader(s2, i);
    }

    public void setStatus(int i) {
        this.httpResponse.setStatus(i);
    }

    public void setStatus(int i, String s2) {
        this.httpResponse.setStatus(i, s2);
    }

    public String getCharacterEncoding() {
        return this.httpResponse.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.httpResponse.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.httpResponse.getWriter();
    }

    public void setContentLength(int i) {
        this.httpResponse.setContentLength(i);
    }

    public void setContentType(String s2) {
        this.httpResponse.setContentType(s2);
    }

    public void setBufferSize(int i) {
        this.httpResponse.setBufferSize(i);
    }

    public int getBufferSize() {
        return this.httpResponse.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.httpResponse.flushBuffer();
    }

    public void resetBuffer() {
        this.httpResponse.resetBuffer();
    }

    public boolean isCommitted() {
        return this.httpResponse.isCommitted();
    }

    public void reset() {
        this.httpResponse.reset();
    }

    public void setLocale(Locale locale) {
        this.httpResponse.setLocale(locale);
    }

    public Locale getLocale() {
        return this.httpResponse.getLocale();
    }
}

