/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.doxia.logging.PlexusLoggerWrapper;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.apache.maven.doxia.parser.module.ParserModuleManager;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.XmlValidator;
import org.apache.velocity.VelocityContext;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.SiteResourceLoader;
import org.codehaus.plexus.velocity.VelocityComponent;

public abstract class AbstractDocumentRenderer
extends AbstractLogEnabled
implements DocumentRenderer {
    @Requirement
    protected ParserModuleManager parserModuleManager;
    @Requirement
    protected Doxia doxia;
    @Requirement
    private VelocityComponent velocity;
    private String baseDir;

    public abstract void render(Map<String, ParserModule> var1, File var2, DocumentModel var3) throws DocumentRendererException, IOException;

    @Override
    public void render(Collection<String> files, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(this.getFilesToProcess(files), outputDirectory, documentModel, null);
    }

    @Override
    public void render(File baseDirectory, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(baseDirectory, outputDirectory, documentModel, null);
    }

    public void render(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
    }

    public void render(File baseDirectory, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
        this.render(this.getFilesToProcess(baseDirectory), outputDirectory, documentModel, context);
    }

    public void render(File baseDirectory, File outputDirectory) throws DocumentRendererException, IOException {
        this.render(baseDirectory, outputDirectory, (DocumentModel)null);
    }

    public void render(File baseDirectory, File outputDirectory, File documentDescriptor) throws DocumentRendererException, IOException {
        if (documentDescriptor == null || !documentDescriptor.exists()) {
            this.getLogger().warn("No documentDescriptor found: using default settings!");
            this.render(baseDirectory, outputDirectory);
        } else {
            this.render(this.getFilesToProcess(baseDirectory), outputDirectory, this.readDocumentModel(documentDescriptor), null);
        }
    }

    public void renderIndividual(Map<String, ParserModule> filesToProcess, File outputDirectory) throws DocumentRendererException, IOException {
    }

    public void renderIndividual(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentRendererContext context) throws DocumentRendererException, IOException {
    }

    public Map<String, ParserModule> getFilesToProcess(File baseDirectory) throws IOException, DocumentRendererException {
        if (!baseDirectory.isDirectory()) {
            this.getLogger().warn("No files found to process!");
            return new HashMap<String, ParserModule>();
        }
        this.setBaseDir(baseDirectory.getAbsolutePath());
        LinkedHashMap<String, ParserModule> filesToProcess = new LinkedHashMap<String, ParserModule>();
        LinkedHashMap<String, String> duplicatesFiles = new LinkedHashMap<String, String>();
        Collection<ParserModule> modules = this.parserModuleManager.getParserModules();
        for (ParserModule module : modules) {
            File moduleBasedir = new File(baseDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List<String> allFiles = FileUtils.getFileNames(moduleBasedir, "**/*.*", null, false);
            String[] extensions = AbstractDocumentRenderer.getExtensions(module);
            LinkedList<String> docs = new LinkedList<String>(allFiles);
            Iterator it = docs.iterator();
            while (it.hasNext()) {
                String name = ((String)it.next()).trim();
                if (AbstractDocumentRenderer.endsWithIgnoreCase(name, extensions)) continue;
                it.remove();
            }
            String[] vmExtensions = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                vmExtensions[i] = extensions[i] + ".vm";
            }
            LinkedList<String> velocityFiles = new LinkedList<String>(allFiles);
            Iterator it2 = velocityFiles.iterator();
            while (it2.hasNext()) {
                String name = ((String)it2.next()).trim();
                if (AbstractDocumentRenderer.endsWithIgnoreCase(name, vmExtensions)) continue;
                it2.remove();
            }
            docs.addAll(velocityFiles);
            for (String filePath : docs) {
                if ((filePath = filePath.trim()).lastIndexOf(46) > 0) {
                    String key = filePath.substring(0, filePath.lastIndexOf(46));
                    if (duplicatesFiles.containsKey(key)) {
                        throw new DocumentRendererException("Files '" + module.getSourceDirectory() + File.separator + filePath + "' clashes with existing '" + (String)duplicatesFiles.get(key) + "'.");
                    }
                    duplicatesFiles.put(key, module.getSourceDirectory() + File.separator + filePath);
                }
                filesToProcess.put(filePath, module);
            }
        }
        return filesToProcess;
    }

    protected static String[] getExtensions(ParserModule module) {
        String[] extensions = new String[module.getExtensions().length];
        for (int i = module.getExtensions().length - 1; i >= 0; --i) {
            extensions[i] = '.' + module.getExtensions()[i];
        }
        return extensions;
    }

    protected static boolean endsWithIgnoreCase(String str, String searchStr) {
        if (str.length() < searchStr.length()) {
            return false;
        }
        return str.regionMatches(true, str.length() - searchStr.length(), searchStr, 0, searchStr.length());
    }

    protected static boolean endsWithIgnoreCase(String str, String[] searchStrs) {
        for (String searchStr : searchStrs) {
            if (!AbstractDocumentRenderer.endsWithIgnoreCase(str, searchStr)) continue;
            return true;
        }
        return false;
    }

    public Map<String, ParserModule> getFilesToProcess(Collection<String> files) {
        HashMap<String, ParserModule> filesToProcess = new HashMap<String, ParserModule>();
        Collection<ParserModule> modules = this.parserModuleManager.getParserModules();
        for (ParserModule module : modules) {
            String[] extensions = AbstractDocumentRenderer.getExtensions(module);
            String sourceDirectory = File.separator + module.getSourceDirectory() + File.separator;
            for (String file : files) {
                if (file.indexOf(sourceDirectory) != -1) {
                    filesToProcess.put(file, module);
                    continue;
                }
                if (!AbstractDocumentRenderer.endsWithIgnoreCase(file, extensions) || filesToProcess.containsKey(file)) continue;
                filesToProcess.put(file, module);
            }
        }
        return filesToProcess;
    }

    @Override
    public DocumentModel readDocumentModel(File documentDescriptor) throws DocumentRendererException, IOException {
        DocumentModel documentModel;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(documentDescriptor);
            documentModel = new DocumentXpp3Reader().read(reader);
        }
        catch (XmlPullParserException e) {
            throw new DocumentRendererException("Error parsing document descriptor", e);
        }
        finally {
            IOUtil.close(reader);
        }
        return documentModel;
    }

    public void setBaseDir(String newDir) {
        this.baseDir = newDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected void parse(String fullDocPath, String parserId, Sink sink) throws DocumentRendererException, IOException {
        this.parse(fullDocPath, parserId, sink, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parse(String fullDocPath, String parserId, Sink sink, DocumentRendererContext context) throws DocumentRendererException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parsing file " + fullDocPath);
        }
        Reader reader = null;
        try {
            File f = new File(fullDocPath);
            Parser parser = this.doxia.getParser(parserId);
            switch (parser.getType()) {
                case 2: {
                    reader = ReaderFactory.newXmlReader(f);
                    if (AbstractDocumentRenderer.isVelocityFile(f)) {
                        reader = this.getVelocityReader(f, reader.getEncoding(), context);
                    }
                    if (context == null || !Boolean.TRUE.equals((Boolean)context.get("validate"))) break;
                    reader = this.validate(reader, fullDocPath);
                    break;
                }
                default: {
                    reader = AbstractDocumentRenderer.isVelocityFile(f) ? this.getVelocityReader(f, context == null ? ReaderFactory.FILE_ENCODING : context.getInputEncoding(), context) : (context == null ? ReaderFactory.newPlatformReader(f) : ReaderFactory.newReader(f, context.getInputEncoding()));
                }
            }
            sink.enableLogging(new PlexusLoggerWrapper(this.getLogger()));
            this.doxia.parse(reader, parserId, sink);
        }
        catch (ParserNotFoundException e) {
            try {
                throw new DocumentRendererException("No parser '" + parserId + "' found for " + fullDocPath + ": " + e.getMessage(), e);
                catch (ParseException e2) {
                    throw new DocumentRendererException("Error parsing " + fullDocPath + ": " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                sink.flush();
                throw throwable;
            }
        }
        IOUtil.close(reader);
        sink.flush();
    }

    protected void copyResources(File outputDirectory) throws IOException {
        File resourcesDirectory = new File(this.getBaseDir(), "resources");
        if (!resourcesDirectory.isDirectory()) {
            return;
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.copyDirectory(resourcesDirectory, outputDirectory);
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.isDirectory() && destination.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : includedFiles) {
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile(sourceFile, destinationFile);
            }
        }
    }

    protected String getOutputName(DocumentModel documentModel) {
        String outputName = documentModel.getOutputName();
        if (outputName == null) {
            this.getLogger().info("No outputName is defined in the document descriptor. Using 'target'");
            documentModel.setOutputName("target");
        }
        if ((outputName = outputName.trim()).toLowerCase(Locale.ENGLISH).endsWith("." + this.getOutputExtension())) {
            outputName = outputName.substring(0, outputName.toLowerCase(Locale.ENGLISH).lastIndexOf("." + this.getOutputExtension()));
        }
        documentModel.setOutputName(outputName);
        return documentModel.getOutputName();
    }

    private Reader getVelocityReader(File f, String encoding, DocumentRendererContext context) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Velocity render for " + f.getAbsolutePath());
        }
        SiteResourceLoader.setResource(f.getAbsolutePath());
        VelocityContext velocityContext = new VelocityContext();
        if (context.getKeys() != null) {
            for (int i = 0; i < context.getKeys().length; ++i) {
                String key = (String)context.getKeys()[i];
                velocityContext.put(key, context.get(key));
            }
        }
        StringWriter sw = new StringWriter();
        try {
            this.velocity.getEngine().mergeTemplate(f.getAbsolutePath(), encoding, velocityContext, sw);
        }
        catch (Exception e) {
            throw new DocumentRendererException("Error whenn parsing Velocity file " + f.getAbsolutePath() + ": " + e.getMessage(), e);
        }
        return new StringReader(sw.toString());
    }

    private static boolean isVelocityFile(File f) {
        return FileUtils.getExtension(f.getAbsolutePath()).toLowerCase(Locale.ENGLISH).endsWith("vm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader validate(Reader source, String resource) throws ParseException, IOException {
        this.getLogger().debug("Validating: " + resource);
        try {
            String content = IOUtil.toString(new BufferedReader(source));
            new XmlValidator(new PlexusLoggerWrapper(this.getLogger())).validate(content);
            StringReader stringReader = new StringReader(content);
            return stringReader;
        }
        finally {
            IOUtil.close(source);
        }
    }
}

