/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fml;

import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.fml.FmlMarkup;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FmlContentParser
extends XhtmlBaseParser
implements FmlMarkup {
    private boolean isEmptyElement;

    @Override
    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        if (parser.getName().equals(QUESTION_TAG.toString()) || parser.getName().equals(TITLE.toString()) || parser.getName().equals(ANSWER_TAG.toString())) {
            return;
        }
        if (parser.getName().equals(SOURCE_TAG.toString())) {
            this.verbatim();
            sink.verbatim(SinkEventAttributeSet.BOXED);
        } else if (!this.baseStartTag(parser, sink)) {
            if (this.isEmptyElement) {
                this.handleUnknown(parser, sink, 1);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
            if (this.getLog().isDebugEnabled()) {
                String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
                String tag = "<" + parser.getName() + ">";
                this.getLog().debug("Unrecognized fml tag: " + tag + " at " + position);
            }
        }
    }

    @Override
    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(QUESTION_TAG.toString()) || parser.getName().equals(TITLE.toString()) || parser.getName().equals(ANSWER_TAG.toString())) {
            return;
        }
        if (parser.getName().equals(SOURCE_TAG.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
            this.handleUnknown(parser, sink, 3);
        }
        this.isEmptyElement = false;
    }

    @Override
    protected void init() {
        super.init();
        this.isEmptyElement = false;
    }
}

