/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;

public abstract class ListOf
extends ASNObject {
    private ASNObject[] seqArray;

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional() && !this.isSelected()) {
            os.writeByte(1);
            return;
        }
        if (this.seqArray == null || this.seqArray.length < 1) {
            throw new IOException("ListOf contains no elements");
        }
        int numTlField = 1;
        while (Math.pow(2.0, 4.0 * (double)numTlField) - 1.0 < (double)this.seqArray.length) {
            ++numTlField;
        }
        for (int i = numTlField; i > 0; --i) {
            int firstFourBits = i < numTlField ? (i > 1 ? 128 : 0) : (numTlField > 1 ? 240 : 112);
            os.writeByte(firstFourBits & 0xFF | this.seqArray.length >> (i - 1) * 4 & 0xF);
        }
        for (ASNObject element : this.seqArray) {
            element.encode(os);
        }
    }

    public ASNObject[] seqArray() {
        return this.seqArray;
    }

    protected void seqArray(ASNObject ... seqArray) {
        this.seqArray = seqArray;
    }
}

