/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.openmuc.jsml.structures.ASNObject;

public class OctetString
extends ASNObject {
    private static final int MAX_LENGTH = 32000;
    private byte[] value;

    public OctetString() {
    }

    public OctetString(byte[] octetString) {
        this.set(octetString);
        this.setSelected(true);
    }

    public OctetString(String octetString) {
        this(OctetString.toArray(octetString));
    }

    public byte[] getValue() {
        return this.value;
    }

    public void set(byte[] octetString) {
        if (octetString != null) {
            if (octetString.length < 32000) {
                this.value = octetString;
            }
        } else {
            this.value = new byte[0];
        }
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional() && !this.isSelected()) {
            os.writeByte(1);
            return;
        }
        int numTlField = 1;
        while (Math.pow(2.0, 4.0 * (double)numTlField) - 1.0 - (double)numTlField < (double)this.value.length) {
            ++numTlField;
        }
        for (int i = numTlField; i > 0; --i) {
            int firstFourBits = 0;
            if (i > 1) {
                firstFourBits = 128;
            }
            os.writeByte(firstFourBits & 0xFF | this.value.length + numTlField >> (i - 1) * 4 & 0xF);
        }
        for (byte element : this.value) {
            os.write(element);
        }
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        int tlLength = 1;
        byte typeLength = is.readByte();
        if (this.isOptional() && typeLength == 1) {
            this.setSelected(false);
            return true;
        }
        if ((typeLength & 0x70) >> 4 != 0) {
            return false;
        }
        int length = typeLength & 0xF;
        while ((typeLength & 0x80) == 128) {
            ++tlLength;
            typeLength = is.readByte();
            if ((typeLength & 0x70) >> 4 != 0) {
                return false;
            }
            length = (length & 0xFFFFFFFF) << 4 | typeLength & 0xF;
        }
        this.value = new byte[length -= tlLength];
        for (int i = 0; i < length; ++i) {
            this.value[i] = is.readByte();
        }
        this.setSelected(true);
        return true;
    }

    public byte[] toBytes() {
        return this.value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof OctetString) {
            return Arrays.equals(this.value, ((OctetString)other).toBytes());
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return "not set";
        }
        return this.toHexString();
    }

    public String toDecimalString() {
        StringBuilder asBytes = new StringBuilder();
        for (int i = 0; i < this.value.length - 1; ++i) {
            asBytes.append(this.value[i] & 0xFF).append(".");
        }
        asBytes.append(this.value[this.value.length - 1] & 0xFF);
        return asBytes.toString();
    }

    public String toHexString() {
        StringBuilder asBytes = new StringBuilder();
        for (byte element : this.value) {
            asBytes.append(String.format("%02X ", element));
        }
        return asBytes.toString().trim();
    }

    public static byte[] toArray(String octetString) {
        if (octetString != null) {
            int ln = octetString.length();
            if (ln > 2 && (ln & 1) == 0 && octetString.startsWith("0x")) {
                byte[] buf = new byte[(ln >> 1) - 1];
                for (int i = 2; i < ln; i += 2) {
                    buf[(i >> 1) - 1] = (byte)((Character.digit(octetString.charAt(i), 16) << 4) + Character.digit(octetString.charAt(i + 1), 16));
                }
                return buf;
            }
            return octetString.getBytes();
        }
        return new byte[0];
    }
}

