/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Choice;
import org.openmuc.jsml.structures.SmlTimestamp;
import org.openmuc.jsml.structures.SmlTimestampLocal;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned8;

public class SmlTime
extends Choice {
    public static final int SECINDEX = 1;
    public static final int TIMESTAMP = 2;
    public static final int TIMESTAMP_LOCAL = 3;

    public SmlTime() {
    }

    public SmlTime(int tag, ASNObject choice) {
        this.setTime(tag, choice);
    }

    public void setTime(int tag, ASNObject choice) {
        if (tag != 1 && tag != 2 && tag != 3) {
            throw new IllegalArgumentException("SML_Time: Wrong value for tag! " + tag + " is not allowed.");
        }
        this.choice = choice;
        this.setTag(new Unsigned8(tag));
        this.setSelected(true);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte tlField = is.readByte();
        if (this.isOptional() && tlField == 1) {
            this.setSelected(false);
            return true;
        }
        if ((tlField & 0xFF) != 114 || !this.getTag().decode(is)) {
            return false;
        }
        switch (this.getTag().getVal()) {
            case 1: {
                this.choice = new Unsigned32();
                break;
            }
            case 2: {
                this.choice = new SmlTimestamp();
                break;
            }
            case 3: {
                this.choice = new SmlTimestampLocal();
                break;
            }
            default: {
                throw new IllegalArgumentException("tag number not supported yet: " + this.getTag().getVal());
            }
        }
        if (!this.choice.decode(is)) {
            return false;
        }
        this.setSelected(true);
        return true;
    }

    public String toString() {
        String tagValue;
        switch (this.getTag().getVal()) {
            case 1: {
                tagValue = "SECINDEX";
                break;
            }
            case 2: {
                tagValue = "TIMESTAMP";
                break;
            }
            case 3: {
                tagValue = "TIMESTAMP_LOCAL";
                break;
            }
            default: {
                tagValue = "Unknown tag: " + this.getTag().getVal();
            }
        }
        String value = "unknown";
        if (this.choice instanceof SmlTimestamp) {
            SmlTimestamp timestamp = (SmlTimestamp)this.choice;
            value = String.valueOf(timestamp.getVal());
        } else if (this.choice instanceof Unsigned32) {
            Unsigned32 uint32 = (Unsigned32)this.choice;
            value = uint32.toString();
        }
        return tagValue + " value: " + value;
    }
}

