/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;

public class Unsigned16
extends ASNObject {
    private int val;

    public Unsigned16() {
    }

    public Unsigned16(int i) {
        this.val = i & 0xFFFF;
        this.setSelected(true);
    }

    public int getVal() {
        return this.val;
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional() && !this.isSelected()) {
            os.writeByte(1);
            return;
        }
        os.writeByte(99);
        os.writeShort(this.val & 0xFFFF);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte typeLengthField = is.readByte();
        if (this.isOptional() && typeLengthField == 1) {
            this.setSelected(false);
            return true;
        }
        if ((typeLengthField & 0x60) != 96) {
            return false;
        }
        int length = (typeLengthField & 0xF) - 1;
        --length;
        while (length >= 0) {
            this.val |= is.readUnsignedByte() << 8 * length;
            --length;
        }
        this.setSelected(true);
        return true;
    }

    public String toString() {
        return String.valueOf(this.val);
    }
}

