/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.openmuc.jsml.structures.ASNObject;

public class Unsigned32
extends ASNObject {
    private long val;

    public Unsigned32() {
    }

    public Unsigned32(long val) {
        this.val = val;
        this.setSelected(true);
    }

    public int getVal() {
        return (int)this.val;
    }

    public long getLongValue() {
        return this.val;
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional() && !this.isSelected()) {
            os.writeByte(1);
            return;
        }
        os.writeByte(101);
        byte[] array = ByteBuffer.allocate(4).put((byte)((this.val & 0xFFFFFFFFFF000000L) >> 24)).put((byte)((this.val & 0xFF0000L) >> 16)).put((byte)((this.val & 0xFF00L) >> 8)).put((byte)(this.val & 0xFFL)).array();
        os.write(array);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte typeLengthField = is.readByte();
        if (this.isOptional() && typeLengthField == 1) {
            this.setSelected(false);
            return true;
        }
        if ((typeLengthField & 0x60) != 96) {
            return false;
        }
        for (int length = (typeLengthField & 0xF) - 2; length >= 0; --length) {
            this.val |= (long)is.readUnsignedByte() << 8 * length;
        }
        this.setSelected(true);
        return true;
    }

    public String toString() {
        return String.valueOf(this.getLongValue());
    }
}

