/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification;

import com.google.common.io.BaseEncoding;
import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.DecodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public enum EncodingType {
    BASE64("base64"),
    BASE32("base32"),
    PLAIN("plain"),
    HEX("hex");

    private final String code;

    private EncodingType(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static EncodingType fromCode(String code) {
        for (EncodingType formatType : EncodingType.values()) {
            if (!formatType.code.equals(code)) continue;
            return formatType;
        }
        return null;
    }

    public static List<EncodingType> guessType(String data) {
        return EncodingType.guessType(data, false);
    }

    public static List<EncodingType> guessType(String data, boolean allowPlain) {
        ArrayList<EncodingType> matches = new ArrayList<EncodingType>();
        if (data == null) {
            return matches;
        }
        try {
            EncodingType.base32Decode(data);
            matches.add(BASE32);
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
        try {
            EncodingType.base64Decode(data);
            matches.add(BASE64);
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
        try {
            EncodingType.hexDecode(data);
            matches.add(HEX);
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
        if (allowPlain) {
            matches.add(PLAIN);
        }
        return matches;
    }

    public static byte[] decode(EncodingType type, String data) throws DecodingException {
        switch (type) {
            case HEX: {
                return EncodingType.hexDecode(data);
            }
            case BASE32: {
                return EncodingType.base32Decode(data);
            }
            case BASE64: {
                return EncodingType.base64Decode(data);
            }
        }
        return data.getBytes();
    }

    public byte[] decode(String data) throws DecodingException {
        return EncodingType.decode(this, data);
    }

    public static byte[] hexDecode(String data) throws DecodingException {
        try {
            return Hex.decode(Utils.clearString(data));
        }
        catch (DecoderException e) {
            throw new DecodingException("Invalid hex data", "error.encoding.hex.invalid", e);
        }
    }

    public static byte[] base64Decode(String data) throws DecodingException {
        try {
            String base64Data = Utils.clearString(data);
            return Base64.getDecoder().decode(base64Data);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException("Invalid base 64 data", "error.encoding.base64.invalid", e);
        }
    }

    public static byte[] base32Decode(String data) throws DecodingException {
        try {
            String base32Data = Utils.clearString(data);
            BaseEncoding base32 = BaseEncoding.base32();
            return base32.decode(base32Data);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException("Invalid base 32 data", "error.encoding.base32.invalid", e);
        }
    }
}

